/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket;

import com.mojang.serialization.Codec;
import net.minecraft.util.StringRepresentable;

public enum RocketModel implements StringRepresentable
{
    TINY(0),
    SMALL(1),
    NORMAL(2),
    BIG(3);

    public static final Codec<RocketModel> CODEC;
    private final int id;

    private RocketModel(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "tiny";
            case 1 -> "small";
            case 2 -> "normal";
            case 3 -> "big";
        };
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public static RocketModel fromString(String name) {
        return switch (name) {
            case "tiny" -> TINY;
            case "small" -> SMALL;
            case "normal" -> NORMAL;
            case "big" -> BIG;
            default -> NORMAL;
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(RocketModel::values);
    }
}

