/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.st0x0ef.stellaris.common.config.ConfigEntry;
import com.st0x0ef.stellaris.common.config.CustomConfig;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    private final Screen parent;

    public ConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Stellaris Option"));
        this.parent = parent;
    }

    protected void init() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.defaultCellSetting().paddingHorizontal(5).paddingBottom(4).alignHorizontallyCenter();
        GridLayout.RowHelper rowHelper = gridLayout.createRowHelper(2);
        CustomConfig.CONFIG.forEach((string, configEntry) -> {
            StringWidget widget = new StringWidget((Component)Component.literal((String)string), this.font);
            rowHelper.addChild((LayoutElement)widget);
            this.addTypeWidgets((ConfigEntry)configEntry, rowHelper, (String)string);
            rowHelper.addChild((LayoutElement)SpacerElement.height((int)5), 2);
        });
        Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build();
        rowHelper.addChild((LayoutElement)doneButton, 2, rowHelper.newCellSettings().paddingTop(10));
        gridLayout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridLayout, (int)0, (int)(this.height / 6 + 10), (int)this.width, (int)this.height, (float)0.5f, (float)0.0f);
        gridLayout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void onClose() {
        CustomConfig.writeConfigFile("stellaris.json");
        CustomConfig.loadConfigFile();
        this.playToast((Component)Component.literal((String)"Config Saved"), (Component)Component.literal((String)"The Stellaris config has been saved"));
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
    }

    public void addTypeWidgets(ConfigEntry entry, GridLayout.RowHelper rowHelper, String entryName) {
        if (entry.getType() == Boolean.class) {
            Checkbox checkbox = Checkbox.builder((Component)Component.literal((String)entry.value().toString()), (Font)this.font).selected(((Boolean)entry.value()).booleanValue()).tooltip(Tooltip.create((Component)Component.literal((String)entry.description()), null)).onValueChange((checkbox1, aBoolean) -> CustomConfig.CONFIG.replace(entryName, new ConfigEntry<Boolean>(aBoolean, entry.description()))).build();
            rowHelper.addChild((LayoutElement)checkbox);
        } else if (entry.getType() == String.class) {
            EditBox button = new EditBox(this.font, 50, 15, (Component)Component.literal((String)entry.value().toString()));
            button.setMaxLength(100);
            button.setTooltip(Tooltip.create((Component)Component.literal((String)entry.description()), null));
            button.setValue(entry.value().toString());
            button.setResponder(string -> CustomConfig.CONFIG.replace(entryName, new ConfigEntry<String>((String)string, entry.description())));
            rowHelper.addChild((LayoutElement)button);
        } else if (entry.getType() == Integer.class || entry.getType() == Double.class || entry.getType() == Float.class) {
            EditBox button = new EditBox(this.font, 50, 15, (Component)Component.literal((String)entry.value().toString()));
            button.setMaxLength(100);
            button.setValue(entry.value().toString());
            button.setTooltip(Tooltip.create((Component)Component.literal((String)entry.description()), null));
            button.setResponder(string -> {
                int foo;
                try {
                    foo = Integer.parseInt(string);
                }
                catch (NumberFormatException e) {
                    foo = 0;
                }
                CustomConfig.CONFIG.replace(entryName, new ConfigEntry<Integer>(foo, entry.description()));
            });
            rowHelper.addChild((LayoutElement)button);
        } else {
            SpriteIconButton spriteIconButton = this.stellarisConfigButton(20);
            spriteIconButton.setTooltip(Tooltip.create((Component)Component.literal((String)"This config type is not supported. Use the manual config"), null));
            rowHelper.addChild((LayoutElement)spriteIconButton);
        }
    }

    public void removed() {
        this.minecraft.options.save();
    }

    public void playToast(Component title, Component description) {
        this.minecraft.getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, title, description));
    }

    private SpriteIconButton stellarisConfigButton(int i) {
        return SpriteIconButton.builder((Component)Component.literal((String)"Config"), button -> {
            Path path = Path.of(String.valueOf(Platform.getConfigFolder()) + "/stellaris.json", new String[0]);
            Util.getPlatform().openUri(path.toUri());
        }, (boolean)true).width(i).sprite(new ResourceLocation("stellaris", "textures/item/engine_fan.png"), 16, 16).build();
    }
}

