/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.Gauge;
import com.st0x0ef.stellaris.common.blocks.entities.machines.oxygen.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.menus.OxygenDistributorMenu;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OxygenDistributorScreen
extends AbstractContainerScreen<OxygenDistributorMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("stellaris", "textures/gui/oxygen_distributor.png");
    private final OxygenDistributorBlockEntity blockEntity = ((OxygenDistributorMenu)this.getMenu()).getBlockEntity();
    private Gauge energyGauge;

    public OxygenDistributorScreen(OxygenDistributorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 177;
        this.imageHeight = 220;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        WrappedBlockEnergyContainer energyContainer = this.blockEntity.getWrappedEnergyContainer();
        this.energyGauge = new Gauge(this.leftPos + 147, this.topPos + 55, 13, 48, (Component)Component.translatable((String)"stellaris.screen.energy"), GUISprites.ENERGY_FULL, GUISprites.BATTERY_OVERLAY, (int)energyContainer.getStoredEnergy(), (int)energyContainer.getMaxCapacity());
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge.update(this.blockEntity.getWrappedEnergyContainer().getStoredEnergy());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
    }
}

