/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.Gauge;
import com.st0x0ef.stellaris.common.blocks.entities.machines.SolarPanelEntity;
import com.st0x0ef.stellaris.common.menus.SolarPanelMenu;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SolarPanelScreen
extends AbstractContainerScreen<SolarPanelMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("stellaris", "textures/gui/solar_panel.png");
    private final SolarPanelEntity blockEntity = ((SolarPanelMenu)this.getMenu()).getBlockEntity();
    private Gauge energyGauge;

    public SolarPanelScreen(SolarPanelMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.imageWidth = 177;
        this.imageHeight = 228;
        this.inventoryLabelY = this.imageHeight - 92;
        this.titleLabelY += 40;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge = new Gauge(this.leftPos + 108, this.topPos + 69, 13, 47, (Component)Component.translatable((String)"stellaris.screen.energy"), GUISprites.ENERGY_FULL, null, (int)((SolarPanelMenu)this.menu).getEnergyContainer().getStoredEnergy(), (int)((SolarPanelMenu)this.menu).getEnergyContainer().getMaxCapacity());
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge.update(this.blockEntity.getWrappedEnergyContainer().getStoredEnergy());
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.translatable((String)"gauge_text.stellaris.max_generation", (Object[])new Object[]{((SolarPanelMenu)this.getMenu()).getBlockEntity().getEnergyGeneratedPT()}));
        this.energyGauge.renderTooltips(guiGraphics, x, y, this.font, components);
    }
}

