/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.Gauge;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WaterSeparatorBlockEntity;
import com.st0x0ef.stellaris.common.menus.WaterSeparatorMenu;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WaterSeparatorScreen
extends AbstractContainerScreen<WaterSeparatorMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("stellaris", "textures/gui/water_separator.png");
    private final WaterSeparatorBlockEntity blockEntity = ((WaterSeparatorMenu)this.getMenu()).getBlockEntity();
    private Gauge ingredientTankGauge;
    private Gauge resultTank1Gauge;
    private Gauge resultTank2Gauge;
    private Gauge.SidewayGauge energyGauge;

    public WaterSeparatorScreen(WaterSeparatorMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 177;
        this.imageHeight = 224;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        FluidTank ingredientTank = this.blockEntity.getIngredientTank();
        this.ingredientTankGauge = new Gauge(this.leftPos + 50, this.topPos + 58, 76, 42, (Component)Component.translatable((String)"stellaris.screen.water"), GUISprites.WATER_OVERLAY, GUISprites.WATER_SEPARATOR_OVERLAY, ingredientTank.getAmount(), ingredientTank.getMaxCapacity() - 1L);
        this.addRenderableWidget((GuiEventListener)this.ingredientTankGauge);
        FluidTank resultTank1 = (FluidTank)this.blockEntity.getResultTanks().getFirst();
        this.resultTank1Gauge = new Gauge(this.leftPos + 22, this.topPos + 54, 12, 46, (Component)Component.translatable((String)"stellaris.screen.hydrogen"), GUISprites.HYDROGEN_OVERLAY, GUISprites.LIQUID_TANK_OVERLAY, resultTank1.getAmount(), resultTank1.getMaxCapacity() - 1L);
        this.addRenderableWidget((GuiEventListener)this.resultTank1Gauge);
        FluidTank resultTank2 = (FluidTank)this.blockEntity.getResultTanks().get(1);
        this.resultTank2Gauge = new Gauge(this.leftPos + 142, this.topPos + 54, 12, 46, (Component)Component.translatable((String)"stellaris.screen.oxygen"), GUISprites.OXYGEN_OVERLAY, GUISprites.LIQUID_TANK_OVERLAY, resultTank2.getAmount(), resultTank2.getMaxCapacity() - 1L);
        this.addRenderableWidget((GuiEventListener)this.resultTank2Gauge);
        WrappedBlockEnergyContainer energyContainer = this.blockEntity.getWrappedEnergyContainer();
        this.energyGauge = new Gauge.SidewayGauge(this.leftPos + 64, this.topPos + 24, 47, 13, (Component)Component.translatable((String)"stellaris.screen.energy"), GUISprites.SIDEWAYS_ENERGY_FULL, GUISprites.SIDEWAYS_ENERGY_OVERLAY, (long)((int)energyContainer.getStoredEnergy()), (int)energyContainer.getMaxCapacity());
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.ingredientTankGauge.update(this.blockEntity.getIngredientTank().getAmount());
        this.resultTank1Gauge.update(((FluidTank)this.blockEntity.getResultTanks().getFirst()).getAmount());
        this.resultTank2Gauge.update(((FluidTank)this.blockEntity.getResultTanks().getLast()).getAmount());
        this.energyGauge.update(this.blockEntity.getWrappedEnergyContainer().getStoredEnergy());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.ingredientTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.resultTank1Gauge.renderTooltip(guiGraphics, x, y, this.font);
        this.resultTank2Gauge.renderTooltip(guiGraphics, x, y, this.font);
        this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
    }
}

