/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.info;

import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.info.PlanetInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class MoonInfo
extends CelestialBody {
    public final PlanetInfo orbitCenter;
    private final long orbitalPeriod;
    public final double orbitRadius;
    public double currentAngle;

    public MoonInfo(ResourceLocation texture, String name, double orbitRadius, long orbitalPeriod, int width, int height, PlanetInfo orbitCenter, ResourceKey<Level> dimension, Component translatable, String id) {
        super(texture, name, 0.0f, 0.0f, width, height, 0xFFFFFF, dimension.location(), translatable, id);
        this.orbitRadius = orbitRadius;
        this.orbitalPeriod = orbitalPeriod;
        this.orbitCenter = orbitCenter;
        this.currentAngle = 0.0;
        this.translatable = translatable;
        this.id = id;
    }

    public double updateAngle(long currentTime) {
        this.currentAngle = (double)(currentTime % this.orbitalPeriod) * (Math.PI * 2 / (double)this.orbitalPeriod);
        return this.currentAngle;
    }

    public void updatePosition() {
        this.x = (float)((double)this.orbitCenter.x + this.orbitRadius * Math.cos(this.currentAngle));
        this.y = this.orbitCenter.y + this.orbitRadius * Math.sin(this.currentAngle);
    }

    @Override
    public String getId() {
        return super.getId();
    }
}

