/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.info;

import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PlanetInfo
extends CelestialBody {
    private final long orbitDuration;
    public final CelestialBody orbitCenter;
    public final double orbitRadius;
    public double currentAngle;

    public PlanetInfo(ResourceLocation texture, String name, double orbitRadius, long orbitDuration, int width, int height, CelestialBody orbitCenter, ResourceKey<Level> dimension, Component translatable, String id) {
        super(texture, name, 0.0f, 0.0f, width, height, 0xFFFFFF, dimension.location(), translatable, id);
        this.orbitRadius = orbitRadius;
        this.orbitDuration = orbitDuration;
        this.orbitCenter = orbitCenter;
        this.currentAngle = 0.0;
        this.translatable = translatable;
        this.id = id;
    }

    public double updateAngle(long currentTime) {
        double orbitProgress = (double)(currentTime % this.orbitDuration) / (double)this.orbitDuration;
        this.currentAngle = orbitProgress * 2.0 * Math.PI;
        return this.currentAngle;
    }

    public void updatePosition() {
        this.x = (float)((double)this.orbitCenter.x + this.orbitRadius * Math.cos(this.currentAngle));
        this.y = (float)(this.orbitCenter.y + this.orbitRadius * Math.sin(this.currentAngle));
    }

    @Override
    public String getId() {
        return super.getId();
    }
}

