/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.skys;

import com.mojang.blaze3d.vertex.PoseStack;
import com.st0x0ef.stellaris.client.skys.record.SkyProperties;
import com.st0x0ef.stellaris.client.skys.renderer.SkyRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PlanetSky
extends DimensionSpecialEffects {
    private final SkyRenderer renderer;
    private final SkyProperties properties;

    public PlanetSky(SkyProperties properties) {
        super(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, false);
        this.properties = properties;
        this.renderer = new SkyRenderer(properties);
    }

    @NotNull
    public Vec3 getBrightnessDependentFogColor(Vec3 fogColor, float brightness) {
        return this.getProperties().fog() != false ? fogColor.multiply((double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.94f + 0.06f), (double)(brightness * 0.91f + 0.09f)) : fogColor;
    }

    public boolean isFoggyAt(int x, int y) {
        return false;
    }

    public void renderSky(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera) {
        this.getRenderer().render(Minecraft.getInstance(), Minecraft.getInstance().level, poseStack, projectionMatrix, partialTick, camera);
    }

    public SkyRenderer getRenderer() {
        return this.renderer;
    }

    public SkyProperties getProperties() {
        return this.properties;
    }
}

