/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.skys.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.st0x0ef.stellaris.client.skys.record.CustomVanillaObject;
import com.st0x0ef.stellaris.client.skys.record.SkyObject;
import com.st0x0ef.stellaris.client.skys.record.SkyProperties;
import com.st0x0ef.stellaris.client.skys.utils.SkyHelper;
import com.st0x0ef.stellaris.client.skys.utils.StarHelper;
import com.st0x0ef.stellaris.mixin.client.LevelRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SkyRenderer {
    private final SkyProperties properties;
    private final VertexBuffer starBuffer;

    public SkyRenderer(SkyProperties properties) {
        this.properties = properties;
        this.starBuffer = properties.stars().colored() ? StarHelper.createStars(0.1f, properties.stars().count(), 190, 160, -1) : StarHelper.createStars(0.1f, properties.stars().count(), 255, 255, 255);
    }

    public void render(Minecraft mc, ClientLevel level, PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, Camera camera) {
        FogType cameraSubmersionType = camera.getFluidInCamera();
        if (cameraSubmersionType.equals((Object)FogType.POWDER_SNOW) || cameraSubmersionType.equals((Object)FogType.LAVA) || mc.levelRenderer.doesMobEffectBlockSky(camera)) {
            return;
        }
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        ShaderInstance shaderInstance = RenderSystem.getShader();
        CustomVanillaObject customVanillaObject = this.properties.customVanillaObject();
        VertexBuffer darkBuffer = ((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).stellaris$getDarkBuffer();
        float dayAngle = level.getTimeOfDay(partialTick) * 360.0f % 360.0f;
        Vec3 vec3 = level.getSkyColor(camera.getPosition(), partialTick);
        float r = (float)vec3.x;
        float g = (float)vec3.y;
        float b = (float)vec3.z;
        FogRenderer.levelFogColor();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        SkyHelper.drawSky(mc, poseStack.last().pose(), projectionMatrix, shaderInstance);
        this.renderStars(level, dayAngle, partialTick, poseStack, projectionMatrix, camera);
        if (customVanillaObject.sun()) {
            SkyHelper.drawCelestialBody(customVanillaObject.sunTexture(), bufferBuilder, poseStack, 100.0f, 30.0f, dayAngle, true);
        }
        if (customVanillaObject.moon()) {
            SkyHelper.drawMoonWithPhase(level, bufferBuilder, poseStack, -100.0f, customVanillaObject, dayAngle);
        }
        for (SkyObject skyObject : this.properties.skyObjects()) {
            SkyHelper.drawCelestialBody(skyObject, bufferBuilder, poseStack, 100.0f, dayAngle, skyObject.blend());
        }
        double d = mc.player.getEyePosition((float)partialTick).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level);
        if (d < 0.0) {
            poseStack.pushPose();
            poseStack.translate(0.0f, 12.0f, 0.0f);
            darkBuffer.bind();
            darkBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, shaderInstance);
            VertexBuffer.unbind();
            poseStack.popPose();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderStars(ClientLevel level, float dayAngle, float partialTick, PoseStack poseStack, Matrix4f projectionMatrix, Camera camera) {
        float rainLevel = 1.0f - level.getRainLevel(partialTick);
        float starLight = level.getStarBrightness(partialTick) * rainLevel;
        if (starLight > 0.0f) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f), (float)(starLight + 0.5f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, camera, dayAngle);
        } else if (this.properties.stars().allDaysVisible()) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f), (float)(starLight + 1.0f));
            StarHelper.drawStars(this.starBuffer, poseStack, projectionMatrix, camera, dayAngle);
        }
    }

    public Boolean shouldRemoveCloud() {
        return this.properties.cloud() == false;
    }

    public Boolean shouldRemoveSnowAndRain() {
        return this.properties.weather().isEmpty();
    }
}

