/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.armors;

import com.st0x0ef.stellaris.common.data_components.SpaceArmorComponent;
import com.st0x0ef.stellaris.common.items.CustomArmorItem;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class AbstractSpaceArmor
extends CustomArmorItem {
    public AbstractSpaceArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public static class Chestplate
    extends AbstractSpaceArmor {
        public Chestplate(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
            super(material, type, properties);
        }

        public void onArmorTick(ItemStack stack, Level level, Player player) {
            if (!PlanetUtil.hasOxygen(level.dimension().location())) {
                this.addOxygen(stack, -1);
            }
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
            SpaceArmorComponent component = (SpaceArmorComponent)stack.get((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get());
            if (component != null) {
                tooltipComponents.add((Component)Component.translatable((String)"jetsuit.stellaris.fuel", (Object[])new Object[]{component.fuel()}));
                tooltipComponents.add((Component)Component.translatable((String)"jetsuit.stellaris.oxygen", (Object[])new Object[]{component.oxygen()}));
            }
        }

        public void addOxygen(ItemStack stack, int amount) {
            SpaceArmorComponent component = (SpaceArmorComponent)stack.get((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get());
            SpaceArmorComponent newComponent = new SpaceArmorComponent(component.fuel(), component.oxygen() + amount);
            stack.set((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get(), (Object)newComponent);
        }

        public void addFuel(ItemStack stack, int amount) {
            SpaceArmorComponent component = (SpaceArmorComponent)stack.get((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get());
            SpaceArmorComponent newComponent = new SpaceArmorComponent(component.fuel() + (long)amount, component.oxygen());
            stack.set((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get(), (Object)newComponent);
        }

        public long getFuel(ItemStack stack) {
            return ((SpaceArmorComponent)stack.get((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get())).fuel();
        }

        public int getOxygen(ItemStack stack) {
            return ((SpaceArmorComponent)stack.get((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get())).oxygen();
        }

        public int getMaxOxygen() {
            return 10000;
        }
    }
}

