/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.blocks.entities.RadioactiveBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RadioactiveBlock
extends BaseEntityBlock {
    public static final MapCodec<RadioactiveBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RadioactiveBlock.propertiesCodec(), (App)Codec.INT.fieldOf("level").forGetter(RadioactiveBlock::getRadioactivityLevel)).apply((Applicative)i, RadioactiveBlock::new));
    private final int radioactivityLevel;

    public RadioactiveBlock(BlockBehaviour.Properties properties, int level) {
        super(properties);
        this.radioactivityLevel = level;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RadioactiveBlockEntity(pos, state, this.radioactivityLevel);
    }

    public <T2 extends BlockEntity> BlockEntityTicker<T2> getTicker(Level level, BlockState state, BlockEntityType<T2> type) {
        return (l, p, s, e) -> {
            if (e instanceof RadioactiveBlockEntity) {
                RadioactiveBlockEntity entity = (RadioactiveBlockEntity)e;
                entity.tick();
            }
        };
    }

    public int getRadioactivityLevel() {
        return this.radioactivityLevel;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

