/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.TickingBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WrappedEnergyBlockEntity;
import com.st0x0ef.stellaris.common.systems.energy.base.EnergyBlock;
import com.st0x0ef.stellaris.common.systems.energy.impl.SimpleEnergyContainer;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEnergyBlockEntity
extends BlockEntity
implements EnergyBlock<WrappedBlockEnergyContainer>,
WrappedEnergyBlockEntity,
TickingBlockEntity {
    private WrappedBlockEnergyContainer energyContainer;

    public BaseEnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract int getMaxCapacity();

    @Override
    public WrappedBlockEnergyContainer getEnergyStorage(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer(entity, new SimpleEnergyContainer(this.getMaxCapacity(), Integer.MAX_VALUE))) : this.energyContainer;
    }

    @Override
    public WrappedBlockEnergyContainer getWrappedEnergyContainer() {
        return this.getEnergyStorage(this.getLevel(), this.getBlockPos(), this.getBlockState(), this, null);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.getWrappedEnergyContainer().setEnergy(tag.getLong("stellaris.energy"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putLong("stellaris.energy", this.getWrappedEnergyContainer().getStoredEnergy());
    }
}

