/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseGeneratorBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.CoalGeneratorBlock;
import com.st0x0ef.stellaris.common.menus.CoalGeneratorMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.systems.energy.EnergyApi;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CoalGeneratorEntity
extends BaseGeneratorBlockEntity {
    private int litTime;
    private int litDuration;
    public final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return CoalGeneratorEntity.this.litTime;
                }
                case 1: {
                    return CoalGeneratorEntity.this.litDuration;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    CoalGeneratorEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    CoalGeneratorEntity.this.litDuration = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public CoalGeneratorEntity(BlockPos blockPos, BlockState blockState) {
        this(BlockEntityRegistry.COAL_GENERATOR.get(), blockPos, blockState, 3, 30000);
    }

    public CoalGeneratorEntity(BlockEntityType<?> entityType, BlockPos blockPos, BlockState blockState, int energyGeneratedPT, int maxCapacity) {
        super(entityType, blockPos, blockState, energyGeneratedPT, maxCapacity);
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new CoalGeneratorMenu(containerId, inventory, (Container)this, this, this.dataAccess);
    }

    @Override
    public void tick() {
        WrappedBlockEnergyContainer energyContainer = this.getWrappedEnergyContainer();
        boolean wasLit = this.isLit();
        boolean shouldUpdate = false;
        if (this.canGenerate()) {
            --this.litTime;
        }
        ItemStack stack = (ItemStack)this.getItems().getFirst();
        if (!this.isLit() && !stack.isEmpty()) {
            this.litDuration = this.litTime = this.getBurnDuration(stack);
            if (this.isLit()) {
                shouldUpdate = true;
                Item item = stack.getItem();
                stack.shrink(1);
                if (stack.isEmpty()) {
                    Item item2 = item.getCraftingRemainingItem();
                    this.getItems().set(0, (Object)(item2 == null ? ItemStack.EMPTY : new ItemStack((ItemLike)item2)));
                }
            }
        }
        if (wasLit != this.isLit()) {
            shouldUpdate = true;
            BlockState state = (BlockState)this.getBlockState().setValue((Property)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            this.level.setBlock(this.getBlockPos(), state, 3);
        }
        if (shouldUpdate) {
            CoalGeneratorEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
        }
        if (this.isLit()) {
            if (energyContainer.getStoredEnergy() < energyContainer.getMaxCapacity()) {
                energyContainer.setEnergy(energyContainer.getStoredEnergy() + (long)this.getEnergyGeneratedPT());
            } else if (energyContainer.getStoredEnergy() > energyContainer.getMaxCapacity()) {
                energyContainer.setEnergy(energyContainer.getMaxCapacity());
            }
        }
        EnergyApi.distributeEnergyNearby((BlockEntity)this, 100L);
    }

    protected int getBurnDuration(ItemStack fuelStack) {
        if (fuelStack.isEmpty() || !fuelStack.is(TagRegistry.COAL_GENERATOR_FUEL_TAG)) {
            return 0;
        }
        return AbstractFurnaceBlockEntity.getFuel().getOrDefault(fuelStack.getItem(), 0);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    public boolean canGenerate() {
        WrappedBlockEnergyContainer energyContainer = this.getWrappedEnergyContainer();
        boolean isMaxEnergy = energyContainer.getStoredEnergy() == energyContainer.getMaxCapacity();
        return this.isLit() && !isMaxEnergy;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.litTime = tag.getShort("BurnTime");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putShort("BurnTime", (short)this.litTime);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.coal_generator");
    }

    @Override
    public int getContainerSize() {
        return 1;
    }

    @Override
    protected int getMaxCapacity() {
        return 128000;
    }
}

