/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.data_components.SpaceArmorComponent;
import com.st0x0ef.stellaris.common.items.oxygen.OxygenTankItem;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidBucketHooks;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.platform.Platform;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidTankHelper {
    public static final long BUCKET_AMOUNT = FluidStackHooks.bucketAmount();
    public static final long OXYGEN_TANK_FILL_AMOUNT = Platform.isFabric() ? 810L : 10L;

    public static <T extends BlockEntity> void extractFluidToItem(T blockEntity, FluidTank tank, int slot) {
        ItemStack inputStack = ((Container)blockEntity).getItem(slot);
        if (!inputStack.isEmpty() && !tank.isEmpty()) {
            Item item = inputStack.getItem();
            boolean isTank = item instanceof OxygenTankItem;
            if (tank.getAmount() >= BUCKET_AMOUNT || isTank && tank.getAmount() >= OXYGEN_TANK_FILL_AMOUNT) {
                ItemStack stack;
                ItemStack resultStack = ItemStack.EMPTY;
                if (isTank && tank.getStack().getFluid().isSame((Fluid)FluidRegistry.OXYGEN_STILL.get())) {
                    resultStack = inputStack.copy();
                    long storedOxygen = OxygenTankItem.getStoredOxygen(resultStack);
                    if (storedOxygen + OXYGEN_TANK_FILL_AMOUNT > ((OxygenTankItem)item).getCapacity()) {
                        return;
                    }
                    OxygenTankItem.setStoredOxygen(resultStack, storedOxygen + OXYGEN_TANK_FILL_AMOUNT);
                    tank.shrink(OXYGEN_TANK_FILL_AMOUNT);
                } else if (!isTank && FluidTankHelper.isEmptyBucket(inputStack.getItem()) && !(stack = new ItemStack((ItemLike)tank.getStack().getFluid().getBucket())).isEmpty() && !FluidTankHelper.isEmptyBucket(stack.getItem())) {
                    resultStack = stack;
                    tank.shrink(BUCKET_AMOUNT);
                }
                if (!resultStack.isEmpty()) {
                    ((Container)blockEntity).setItem(slot, resultStack);
                    blockEntity.setChanged();
                }
            }
        }
    }

    public static boolean isEmptyBucket(Item item) {
        BucketItem bucketItem;
        return item instanceof BucketItem && FluidBucketHooks.getFluid((BucketItem)(bucketItem = (BucketItem)item)).isSame(Fluids.EMPTY);
    }

    public static <T extends BlockEntity> void extractFluidToItem(T blockEntity, FluidTank tank, int inputSlot, int outputSlot) {
        boolean hasSpace;
        ItemStack outputStack = ((Container)blockEntity).getItem(outputSlot);
        ItemStack inputStack = ((Container)blockEntity).getItem(inputSlot);
        boolean bl = hasSpace = outputStack.getCount() < outputStack.getMaxStackSize();
        if (!inputStack.isEmpty() && (outputStack.isEmpty() || hasSpace)) {
            boolean canFuel = inputStack.has((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get());
            if (!tank.isEmpty() && (tank.getAmount() >= BUCKET_AMOUNT || canFuel)) {
                ItemStack resultStack = ItemStack.EMPTY;
                if (FluidTankHelper.isEmptyBucket(inputStack.getItem())) {
                    resultStack = new ItemStack((ItemLike)tank.getStack().getFluid().getBucket());
                } else if (canFuel) {
                    resultStack = inputStack.copy();
                }
                if (!resultStack.isEmpty()) {
                    boolean success = false;
                    long amount = BUCKET_AMOUNT;
                    if (outputStack.isEmpty()) {
                        ((Container)blockEntity).setItem(outputSlot, resultStack);
                        success = true;
                    } else if (ItemStack.isSameItem((ItemStack)outputStack, (ItemStack)resultStack) && hasSpace) {
                        outputStack.grow(1);
                        success = true;
                    }
                    if (success) {
                        if (canFuel) {
                            SpaceArmorComponent component = (SpaceArmorComponent)inputStack.get((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get());
                            long fuel = component.fuel();
                            amount = Math.min(SpaceArmorComponent.MAX_CAPACITY - fuel, tank.getAmount());
                            resultStack.set((DataComponentType)DataComponentsRegistry.SPACE_ARMOR_ROCKET.get(), (Object)new SpaceArmorComponent(Mth.clamp((long)(fuel + amount), (long)0L, (long)SpaceArmorComponent.MAX_CAPACITY), component.oxygen()));
                        }
                        inputStack.shrink(1);
                        tank.shrink(amount);
                        blockEntity.setChanged();
                    }
                }
            }
        }
    }

    public static void addToTank(FluidTank tank, FluidStack stack) {
        FluidStack tankStack = tank.getStack();
        if (tankStack.isEmpty()) {
            tank.setFluid(stack.getFluid(), stack.getAmount());
        } else if (tank.getStack().isFluidEqual(stack)) {
            tank.grow(stack.getAmount());
        }
    }

    public static <T extends BlockEntity> boolean addFluidFromBucket(T blockEntity, FluidTank tank, int inputSlot, int outputSlot) {
        if (tank.getAmount() + BUCKET_AMOUNT < tank.getMaxCapacity()) {
            Item item;
            boolean hasSpace;
            ItemStack inputStack = ((Container)blockEntity).getItem(inputSlot);
            ItemStack outputStack = ((Container)blockEntity).getItem(outputSlot);
            boolean bl = hasSpace = outputStack.getCount() < outputStack.getMaxStackSize();
            if (!inputStack.isEmpty() && (outputStack.isEmpty() || hasSpace) && (item = inputStack.getItem()) instanceof BucketItem) {
                BucketItem item2 = (BucketItem)item;
                Fluid fluid = FluidBucketHooks.getFluid((BucketItem)item2);
                if (!tank.isEmpty() && tank.getStack().getFluid() == fluid || tank.isEmpty() && !fluid.isSame(Fluids.EMPTY)) {
                    if (outputStack.isEmpty()) {
                        ((Container)blockEntity).setItem(outputSlot, new ItemStack((ItemLike)Items.BUCKET));
                    } else if (outputStack.is(Items.BUCKET) && hasSpace) {
                        outputStack.grow(1);
                    } else {
                        return false;
                    }
                    ((Container)blockEntity).setItem(inputSlot, ItemStack.EMPTY);
                    FluidTankHelper.addToTank(tank, FluidStack.create((Fluid)fluid, (long)BUCKET_AMOUNT));
                    blockEntity.setChanged();
                    return true;
                }
            }
        }
        return false;
    }

    public static long convertFromMb(long amount) {
        return amount * 81L;
    }

    public static long convertToMb(long amount) {
        return amount / 81L;
    }
}

