/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.data.recipes.FuelRefineryRecipe;
import com.st0x0ef.stellaris.common.menus.FuelRefineryMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import dev.architectury.fluid.FluidStack;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;

public class FuelRefineryBlockEntity
extends BaseEnergyContainerBlockEntity {
    private final FluidTank ingredientTank = new FluidTank("ingredientTank", 5L);
    private final FluidTank resultTank = new FluidTank("resultTank", 5L);
    private final RecipeManager.CachedCheck<FuelRefineryBlockEntity, FuelRefineryRecipe> cachedCheck = RecipeManager.createCheck((RecipeType)((RecipeType)RecipesRegistry.FUEL_REFINERY_TYPE.get()));

    public FuelRefineryBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.FUEL_REFINERY.get(), pos, state);
    }

    @Override
    public void tick() {
        Optional recipeHolder;
        FluidTankHelper.extractFluidToItem(this, this.resultTank, 2, 3);
        if (!FluidTankHelper.addFluidFromBucket(this, this.ingredientTank, 0, 1)) {
            FluidTankHelper.extractFluidToItem(this, this.ingredientTank, 0, 1);
        }
        if ((recipeHolder = this.cachedCheck.getRecipeFor((Container)this, this.level)).isPresent()) {
            FuelRefineryRecipe recipe = (FuelRefineryRecipe)((RecipeHolder)recipeHolder.get()).value();
            WrappedBlockEnergyContainer energyContainer = this.getWrappedEnergyContainer();
            if (energyContainer.getStoredEnergy() >= recipe.energy()) {
                FluidStack resultStack = recipe.resultStack();
                if ((this.resultTank.isEmpty() || this.resultTank.getStack().isFluidEqual(resultStack)) && this.resultTank.getAmount() + resultStack.getAmount() < this.resultTank.getMaxCapacity()) {
                    energyContainer.extractEnergy(recipe.energy(), false);
                    this.ingredientTank.shrink(recipe.ingredientStack().getAmount());
                    FluidTankHelper.addToTank(this.resultTank, resultStack);
                    this.setChanged();
                }
            }
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.fuel_refinery");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new FuelRefineryMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public int getContainerSize() {
        return 4;
    }

    @Override
    protected int getMaxCapacity() {
        return 6000;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.ingredientTank.load(provider, tag);
        this.resultTank.load(provider, tag);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.ingredientTank.save(provider, tag);
        this.resultTank.save(provider, tag);
    }

    public FluidTank getIngredientTank() {
        return this.ingredientTank;
    }

    public FluidTank getResultTank() {
        return this.resultTank;
    }
}

