/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.ImplementedInventory;
import com.st0x0ef.stellaris.common.data.recipes.RocketStationRecipe;
import com.st0x0ef.stellaris.common.menus.RocketStationMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RocketStationEntity
extends BaseContainerBlockEntity
implements ImplementedInventory {
    private NonNullList<ItemStack> items = NonNullList.withSize((int)15, (Object)ItemStack.EMPTY);
    private final RecipeManager.CachedCheck<RocketStationEntity, RocketStationRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)RecipesRegistry.ROCKET_STATION_TYPE.get()));

    public RocketStationEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.ROCKET_STATION.get(), blockPos, blockState);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.rocket_station");
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return new RocketStationMenu(i, inventory, (Container)this);
    }

    @Override
    public void setChanged() {
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        super.setChanged();
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    @Override
    public int[] getSlotsForFace(Direction direction) {
        return new int[0];
    }

    @Override
    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    @Override
    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return false;
    }

    public void tick(Level level) {
        Optional recipeHolder;
        if (level.isClientSide()) {
            return;
        }
        ItemStack outputStack = this.getItem(14);
        if ((outputStack.isEmpty() || outputStack.getCount() < outputStack.getMaxStackSize()) && (recipeHolder = this.quickCheck.getRecipeFor((Container)this, level)).isPresent()) {
            RocketStationRecipe recipe = (RocketStationRecipe)((RecipeHolder)recipeHolder.get()).value();
            ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
            if (outputStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack) && outputStack.getCount() + resultStack.getCount() <= outputStack.getMaxStackSize()) {
                if (outputStack.isEmpty()) {
                    this.setItem(14, resultStack.copy());
                } else if (ItemStack.isSameItemSameComponents((ItemStack)outputStack, (ItemStack)resultStack)) {
                    outputStack.grow(1);
                } else {
                    return;
                }
                for (int i = 0; i < 14; ++i) {
                    ItemStack stack = this.getItem(i);
                    stack.shrink(1);
                    if (!stack.isEmpty()) continue;
                    this.setItem(i, ItemStack.EMPTY);
                }
                this.setChanged();
            }
        }
    }
}

