/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.data.recipes.WaterSeparatorRecipe;
import com.st0x0ef.stellaris.common.menus.WaterSeparatorMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;

public class WaterSeparatorBlockEntity
extends BaseEnergyContainerBlockEntity {
    private static final int TANK_CAPACITY = 3;
    public final FluidTank ingredientTank = new FluidTank("ingredientTank", 3L);
    public final NonNullList<FluidTank> resultTanks = (NonNullList)Util.make((Object)NonNullList.createWithCapacity((int)2), list -> {
        list.add(0, (Object)new FluidTank("resultTank1", 3L));
        list.add(1, (Object)new FluidTank("resultTank2", 3L));
    });
    private final RecipeManager.CachedCheck<WaterSeparatorBlockEntity, WaterSeparatorRecipe> cachedCheck = RecipeManager.createCheck((RecipeType)((RecipeType)RecipesRegistry.WATER_SEPERATOR_TYPE.get()));

    public WaterSeparatorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.WATER_SEPARATOR_ENTITY.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.water_separator");
    }

    @Override
    public int getContainerSize() {
        return 4;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new WaterSeparatorMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public void tick() {
        Optional recipeHolder;
        for (int i = 0; i < 2; ++i) {
            int slot = i + 2;
            FluidTank tank = (FluidTank)this.resultTanks.get(i);
            FluidTankHelper.extractFluidToItem(this, tank, slot);
        }
        if (!FluidTankHelper.addFluidFromBucket(this, this.ingredientTank, 1, 0)) {
            FluidTankHelper.extractFluidToItem(this, this.ingredientTank, 1, 0);
        }
        if ((recipeHolder = this.cachedCheck.getRecipeFor((Container)this, this.level)).isPresent()) {
            WaterSeparatorRecipe recipe = (WaterSeparatorRecipe)((RecipeHolder)recipeHolder.get()).value();
            WrappedBlockEnergyContainer energyContainer = this.getWrappedEnergyContainer();
            if (energyContainer.getStoredEnergy() >= recipe.energy()) {
                List<FluidStack> stacks = recipe.resultStacks();
                FluidStack stack1 = stacks.getFirst();
                FluidStack stack2 = stacks.get(1);
                FluidTank tank1 = (FluidTank)this.resultTanks.getFirst();
                FluidTank tank2 = (FluidTank)this.resultTanks.get(1);
                if ((tank1.isEmpty() || tank1.getStack().isFluidEqual(stack1)) && (tank2.isEmpty() || tank2.getStack().isFluidEqual(stack2)) && tank1.getAmount() + stack1.getAmount() <= tank1.getMaxCapacity() && tank2.getAmount() + stack2.getAmount() <= tank2.getMaxCapacity()) {
                    energyContainer.extractEnergy(recipe.energy(), false);
                    this.ingredientTank.shrink(recipe.ingredientStack().getAmount());
                    FluidTankHelper.addToTank(tank1, stack1);
                    FluidTankHelper.addToTank(tank2, stack2);
                    this.setChanged();
                }
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.ingredientTank.save(provider, tag);
        this.resultTanks.forEach(tank -> tank.save(provider, tag));
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.ingredientTank.load(provider, tag);
        this.resultTanks.forEach(tank -> tank.load(provider, tag));
    }

    @Override
    protected int getMaxCapacity() {
        return 12000;
    }

    public FluidTank getIngredientTank() {
        return this.ingredientTank;
    }

    public NonNullList<FluidTank> getResultTanks() {
        return this.resultTanks;
    }
}

