/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.machines;

import com.mojang.serialization.MapCodec;
import com.st0x0ef.stellaris.common.blocks.entities.machines.CableBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.BaseTickingEntityBlock;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.systems.energy.base.EnergyBlock;
import com.st0x0ef.stellaris.platform.systems.energy.CableUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CableBlock
extends BaseTickingEntityBlock {
    private static final Direction[] DIRECTIONS = Direction.values();
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    protected final VoxelShape[] shapeByIndex;

    public CableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes(0.125f);
    }

    @Override
    public BlockEntityType<?> getBlockEntityType() {
        return BlockEntityRegistry.CABLE_ENTITY.get();
    }

    @Override
    public boolean hasTicker(Level level) {
        return !level.isClientSide;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CableBlock.simpleCodec(CableBlock::new);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level blockGetter = blockPlaceContext.getLevel();
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        BlockEntity blockEntity = blockGetter.getBlockEntity(blockPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.isConnectable(blockEntity, blockGetter.getBlockEntity(blockPos.below()), blockGetter.getBlockState(blockPos.below()), Direction.DOWN)))).setValue((Property)UP, (Comparable)Boolean.valueOf(this.isConnectable(blockEntity, blockGetter.getBlockEntity(blockPos.above()), blockGetter.getBlockState(blockPos.above()), Direction.UP)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.isConnectable(blockEntity, blockGetter.getBlockEntity(blockPos.north()), blockGetter.getBlockState(blockPos.north()), Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.isConnectable(blockEntity, blockGetter.getBlockEntity(blockPos.east()), blockGetter.getBlockState(blockPos.east()), Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.isConnectable(blockEntity, blockGetter.getBlockEntity(blockPos.south()), blockGetter.getBlockState(blockPos.south()), Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.isConnectable(blockEntity, blockGetter.getBlockEntity(blockPos.west()), blockGetter.getBlockState(blockPos.west()), Direction.WEST)));
    }

    private boolean isConnectable(BlockEntity blockEntity, BlockEntity blockEntityTo, BlockState blockStateTo, Direction direction) {
        return blockStateTo.is((Block)this) || blockStateTo.is(TagRegistry.ENERGY_BLOCK_TAG) || blockEntityTo instanceof EnergyBlock || CableUtil.isEnergyContainer(blockEntityTo, direction);
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        BlockEntity blockEntityTo;
        BlockEntity blockEntity = levelAccessor.getBlockEntity(blockPos);
        if (this.isConnectable(blockEntity, blockEntityTo = levelAccessor.getBlockEntity(blockPos.relative(direction)), blockState2, direction)) {
            return (BlockState)blockState.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)blockState.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(false));
    }

    public boolean propagatesSkylightDown(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.getBlock() != blockState2.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof CableBlockEntity) {
                blockState.updateNeighbourShapes((LevelAccessor)level, blockPos, 1);
            }
            super.onRemove(blockState, level, blockPos, blockState2, bl);
        }
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex[this.getAABBIndex(state)];
    }

    private VoxelShape[] makeShapes(float apothem) {
        float f = 0.5f - apothem;
        float g = 0.5f + apothem;
        VoxelShape voxelShape = Block.box((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f), (double)(g * 16.0f));
        VoxelShape[] voxelShapes = new VoxelShape[DIRECTIONS.length];
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Direction direction = DIRECTIONS[i];
            voxelShapes[i] = Shapes.box((double)(0.5 + Math.min((double)(-apothem), (double)direction.getStepX() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.getStepY() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.getStepZ() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.getStepX() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.getStepY() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.getStepZ() * 0.5)));
        }
        VoxelShape[] voxelShapes2 = new VoxelShape[64];
        for (int j = 0; j < 64; ++j) {
            VoxelShape voxelShape2 = voxelShape;
            for (int k = 0; k < DIRECTIONS.length; ++k) {
                if ((j & 1 << k) == 0) continue;
                voxelShape2 = Shapes.or((VoxelShape)voxelShape2, (VoxelShape)voxelShapes[k]);
            }
            voxelShapes2[j] = voxelShape2;
        }
        return voxelShapes2;
    }

    protected int getAABBIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < DIRECTIONS.length; ++j) {
            if (!((Boolean)state.getValue((Property)PROPERTY_BY_DIRECTION.get(DIRECTIONS[j]))).booleanValue()) continue;
            i |= 1 << j;
        }
        return i;
    }
}

