/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.machines.gauge;

import com.st0x0ef.stellaris.common.blocks.machines.gauge.GaugeValueSimple;
import com.st0x0ef.stellaris.common.blocks.machines.gauge.IGaugeValue;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedBlockEnergyContainer;
import com.st0x0ef.stellaris.common.systems.energy.impl.WrappedItemEnergyContainer;
import net.minecraft.resources.ResourceLocation;

public class GaugeValueHelper {
    public static final ResourceLocation ENERGY_NAME = new ResourceLocation("stellaris", "energy");
    public static final ResourceLocation OXYGEN_NAME = new ResourceLocation("stellaris", "oxygen");
    public static final ResourceLocation HYDROGEN_NAME = new ResourceLocation("stellaris", "hydrogen");
    public static final ResourceLocation FLUID_NAME = new ResourceLocation("stellaris", "fluid");
    public static final ResourceLocation FUEL_NAME = new ResourceLocation("stellaris", "fuel");
    public static final ResourceLocation BURNTIME_NAME = new ResourceLocation("stellaris", "burntime");
    public static final ResourceLocation COOKTIME_NAME = new ResourceLocation("stellaris", "cooktime");
    public static final int ENERGY_COLOR = -1593884597;
    public static final int OXYGEN_COLOR = -1610547201;
    public static final int HYDROGEN_COLOR = 0xFFFFFF;
    public static final int FUEL_COLOR = -1600546499;
    public static final int BURNTIME_COLOR = -1593884928;
    public static final int COOKTIME_COLOR = -1593835521;
    public static final String ENERGY_UNIT = "FE";
    public static final String FLUID_UNIT = "mB";

    public static String makeTranslationKey(ResourceLocation name) {
        return "general." + name.getNamespace() + "." + name.getPath();
    }

    public static IGaugeValue getEnergy(long amount) {
        return GaugeValueHelper.getEnergy(amount, 0L);
    }

    public static IGaugeValue getEnergy(long stored, long capacity) {
        return new GaugeValueSimple(ENERGY_NAME, stored, capacity, null, ENERGY_UNIT).color(-1593884597);
    }

    public static IGaugeValue getEnergy(WrappedItemEnergyContainer energyStorage) {
        return GaugeValueHelper.getEnergy(energyStorage.getStoredEnergy(), energyStorage.getMaxCapacity());
    }

    public static IGaugeValue getEnergy(WrappedBlockEnergyContainer blockEntity) {
        return GaugeValueHelper.getEnergy(blockEntity.getStoredEnergy(), blockEntity.getMaxCapacity());
    }

    public static IGaugeValue getBurnTime(int amount) {
        return GaugeValueHelper.getBurnTime(amount, 0L);
    }

    public static IGaugeValue getBurnTime(long amount, long capacity) {
        return new GaugeValueSimple(BURNTIME_NAME, amount, capacity).color(-1593884928);
    }

    public static IGaugeValue getBurnTime(WrappedBlockEnergyContainer fuelPowerSystem) {
        return GaugeValueHelper.getBurnTime(fuelPowerSystem.getStoredEnergy(), fuelPowerSystem.getMaxCapacity());
    }

    public static IGaugeValue getCookTime(int timer, int maxTimer) {
        return new GaugeValueSimple(COOKTIME_NAME, maxTimer - timer, maxTimer).color(-1593835521).reverse(true);
    }

    public static IGaugeValue getFuel(int amount) {
        return GaugeValueHelper.getFuel(amount, 0);
    }

    public static IGaugeValue getFuel(int amount, int capacity) {
        return new GaugeValueSimple(FUEL_NAME, amount, capacity, null, FLUID_UNIT).color(-1600546499);
    }
}

