/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.machines.gauge;

import com.st0x0ef.stellaris.common.blocks.machines.gauge.GaugeValueFluidStack;
import com.st0x0ef.stellaris.common.blocks.machines.gauge.GaugeValueSimple;
import com.st0x0ef.stellaris.common.blocks.machines.gauge.IGaugeValue;
import com.st0x0ef.stellaris.common.systems.util.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class GaugeValueSerializer<T extends Serializable> {
    public static final GaugeValueSerializer Serializer = new GaugeValueSerializer();
    private final Map<ResourceLocation, Class<? extends T>> locationClassMap = new LinkedHashMap<ResourceLocation, Class<? extends T>>();
    private final Map<Class<? extends T>, ResourceLocation> classLocationMap = new LinkedHashMap<Class<? extends T>, ResourceLocation>();

    private GaugeValueSerializer() {
    }

    public T deserialize(CompoundTag compound, HolderLookup.Provider provider) {
        String locationToString = compound.getString("location");
        CompoundTag valueNBT = compound.getCompound("value");
        Class<T> clazz = this.locationClassMap.get(new ResourceLocation(locationToString));
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown class for location: " + locationToString);
        }
        try {
            Serializable format = (Serializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            format.deserialize(valueNBT);
            return (T)format;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to deserialize object", e);
        }
    }

    public void write(T format, FriendlyByteBuf buffer, HolderLookup.Provider provider) {
        buffer.writeNbt((Tag)this.serialize(format, provider));
    }

    public CompoundTag serialize(T format, HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putString("location", this.classLocationMap.get(format.getClass()).toString());
        compound.put("value", (Tag)format.serialize(new CompoundTag()));
        return compound;
    }

    public IGaugeValue read(FriendlyByteBuf buffer, HolderLookup.Provider provider) {
        CompoundTag compound = buffer.readNbt();
        if (compound == null) {
            throw new IllegalArgumentException("Received null compound tag while reading from buffer.");
        }
        return (IGaugeValue)this.deserialize(compound, provider);
    }

    public void addCodec(ResourceLocation location, Class<? extends T> clazz) {
        this.locationClassMap.put(location, clazz);
        this.classLocationMap.put(clazz, location);
    }

    static {
        Serializer.addCodec(new ResourceLocation("stellaris", "fluidstack"), GaugeValueFluidStack.class);
        Serializer.addCodec(new ResourceLocation("stellaris", "simple"), GaugeValueSimple.class);
    }
}

