/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.machines.gauge;

import com.st0x0ef.stellaris.common.blocks.machines.gauge.GaugeValueHelper;
import com.st0x0ef.stellaris.common.blocks.machines.gauge.IGaugeValue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GaugeValueSimple
implements IGaugeValue {
    public static final int FALLBACK_COLOR = -1593835521;
    private ResourceLocation name;
    private long amount;
    private long capacity;
    private Component displayeName;
    private String unit;
    private int color;
    private boolean reverse;
    private Component displayNameCache;

    public GaugeValueSimple() {
        this(null);
    }

    public GaugeValueSimple(ResourceLocation name) {
        this(name, 0L, 0L);
    }

    public GaugeValueSimple(ResourceLocation name, long amount, long capacity) {
        this(name, amount, capacity, null);
    }

    public GaugeValueSimple(ResourceLocation name, long amount, long capacity, @Nullable Component displayeName) {
        this(name, amount, capacity, displayeName, "");
    }

    public GaugeValueSimple(ResourceLocation name, long amount, long capacity, @Nullable Component displayeName, String unit) {
        this(name, amount, capacity, displayeName, unit, -1593835521);
    }

    public GaugeValueSimple(ResourceLocation name, long amount, long capacity, @Nullable Component displayeName, String unit, int color) {
        this.name = name;
        this.amount = amount;
        this.capacity = capacity;
        this.displayeName = displayeName;
        this.unit = unit;
        this.color = color;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public GaugeValueSimple name(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Override
    @Nullable
    public Component getDisplayName() {
        if (this.displayeName != null) {
            return this.displayeName;
        }
        if (this.displayNameCache == null) {
            this.displayNameCache = this.createDefaultTextComponent();
        }
        return this.displayNameCache;
    }

    protected Component createDefaultTextComponent() {
        return Component.translatable((String)GaugeValueHelper.makeTranslationKey(this.getName()));
    }

    public GaugeValueSimple displayeName(Component displayeName) {
        this.displayeName = displayeName;
        return this;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public GaugeValueSimple unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    public GaugeValueSimple amount(long amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    public GaugeValueSimple capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public GaugeValueSimple color(int color) {
        this.color = color;
        return this;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    public GaugeValueSimple reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        CompoundTag compound = new CompoundTag();
        compound.putString("name", this.getName().toString());
        compound.putLong("amount", this.getAmount());
        compound.putLong("capacity", this.getCapacity());
        if (this.getDisplayName() != null) {
            // empty if block
        }
        compound.putString("unit", this.getUnit());
        compound.putInt("color", this.getColor());
        compound.putBoolean("reverse", this.isReverse());
        return compound;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.name(new ResourceLocation(nbt.getString("name")));
        this.amount(nbt.getInt("amount"));
        this.capacity(nbt.getInt("capacity"));
        if (nbt.contains("displayName")) {
            // empty if block
        }
        this.unit(nbt.getString("unit"));
        this.color(nbt.getInt("color"));
        this.reverse(nbt.getBoolean("reverse"));
    }
}

