/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.planets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.data.planets.PlanetTextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record Planet(String system, String translatable, String name, ResourceLocation dimension, boolean oxygen, float temperature, int distanceFromEarth, float gravity, PlanetTextures textures) {
    public static final Codec<Planet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("system").forGetter(Planet::system), (App)Codec.STRING.fieldOf("translatable").forGetter(Planet::translatable), (App)Codec.STRING.fieldOf("name").forGetter(Planet::name), (App)ResourceLocation.CODEC.fieldOf("level").forGetter(Planet::dimension), (App)Codec.BOOL.fieldOf("oxygen").forGetter(Planet::oxygen), (App)Codec.FLOAT.fieldOf("temperature").forGetter(Planet::temperature), (App)Codec.INT.fieldOf("distanceFromEarth").forGetter(Planet::distanceFromEarth), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Planet::gravity), (App)PlanetTextures.CODEC.fieldOf("textures").forGetter(Planet::textures)).apply((Applicative)instance, Planet::new));

    public static RegistryFriendlyByteBuf toBuffer(List<Planet> planets, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(planets.size());
        planets.forEach(planet -> {
            buffer.writeUtf(planet.system);
            buffer.writeUtf(planet.translatable);
            buffer.writeUtf(planet.name);
            buffer.writeResourceLocation(planet.dimension);
            buffer.writeBoolean(planet.oxygen);
            buffer.writeFloat(planet.temperature);
            buffer.writeInt(planet.distanceFromEarth);
            buffer.writeFloat(planet.gravity);
            planet.textures.toNetwork(buffer);
        });
        return buffer;
    }

    public static List<Planet> readFromBuffer(RegistryFriendlyByteBuf buffer) {
        ArrayList<Planet> planets = new ArrayList<Planet>();
        int k = buffer.readInt();
        for (int i = 0; i < k; ++i) {
            planets.add(new Planet(buffer.readUtf(), buffer.readUtf(), buffer.readUtf(), buffer.readResourceLocation(), buffer.readBoolean(), buffer.readFloat(), buffer.readInt(), buffer.readFloat(), PlanetTextures.fromNetwork(buffer)));
        }
        return planets;
    }

    public Component getTranslation() {
        return Component.translatable((String)this.translatable);
    }
}

