/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.planets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class StellarisData
extends SimpleJsonResourceReloadListener {
    private static final List<Planet> PLANETS = new ArrayList<Planet>();

    public StellarisData() {
        super(Stellaris.GSON, "planets");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        PLANETS.clear();
        resourceLocationJsonElementMap.forEach((key, value) -> {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"planets");
            Planet planet = (Planet)Planet.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            PLANETS.add(planet);
        });
    }

    public static List<Planet> getPlanets() {
        return PLANETS;
    }

    public static void addPlanets(List<Planet> planets) {
        PLANETS.clear();
        PLANETS.addAll(planets);
    }
}

