/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities;

import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class IceShardArrowEntity
extends AbstractArrow {
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)ItemsRegistry.ICE_SHARD_ARROW.get());

    public IceShardArrowEntity(EntityType<? extends IceShardArrowEntity> entityType, Level level) {
        super(entityType, level, DEFAULT_ARROW_STACK);
    }

    public IceShardArrowEntity(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        super((EntityType)EntityRegistry.ICE_SHARD_ARROW.get(), livingEntity, level, itemStack);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 150));
        }
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }
}

