/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities;

import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import dev.architectury.networking.NetworkManager;
import java.util.Random;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class IceSpit
extends AbstractArrow
implements ItemSupplier {
    public IceSpit(EntityType<? extends IceSpit> entityType, Level level) {
        super(entityType, level, new ItemStack((ItemLike)ItemsRegistry.ICE_SHARD.get()));
    }

    protected IceSpit(EntityType<? extends AbstractArrow> entityType, LivingEntity livingEntity, Level level, ItemStack itemStack) {
        super(entityType, livingEntity, level, new ItemStack((ItemLike)ItemsRegistry.ICE_SHARD.get()));
    }

    protected ItemStack getDefaultPickupItem() {
        return null;
    }

    @NotNull
    public ItemStack getItem() {
        return new ItemStack((ItemLike)ItemsRegistry.ICE_SHARD.get());
    }

    public static IceSpit shoot(LivingEntity entity, LivingEntity target, int damage) {
        IceSpit entityArrow = new IceSpit((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.ICE_SPIT.get()), entity, entity.level(), new ItemStack((ItemLike)ItemsRegistry.ICE_SHARD.get()));
        double d0 = target.getY() + (double)target.getEyeHeight() - 1.1;
        double d1 = target.getX() - entity.getX();
        double d3 = target.getZ() - entity.getZ();
        entityArrow.shoot(d1, d0 - entityArrow.getY() + Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f, d3, 1.4f, 12.0f);
        entityArrow.setSilent(true);
        entityArrow.setBaseDamage(damage);
        entityArrow.setKnockback(1);
        entityArrow.setCritArrow(false);
        entity.level().addFreshEntity((Entity)entityArrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.GLASS_BREAK, SoundSource.HOSTILE, 1.0f, 1.0f / (new Random().nextFloat() * 0.5f + 1.0f));
        return entityArrow;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }
}

