/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities;

import com.st0x0ef.stellaris.common.entities.IVehicleEntity;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.menus.LanderMenu;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LanderEntity
extends IVehicleEntity
implements HasCustomInventoryScreen {
    public static Consumer<LanderEntity> playBoost = e -> {};
    public static Consumer<LanderEntity> playBeep = e -> {};
    protected SimpleContainer inventory = new SimpleContainer(15);

    public LanderEntity(Level level) {
        this((EntityType)EntityRegistry.LANDER.get(), level);
    }

    public LanderEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void push(Entity p_21294_) {
    }

    @Deprecated
    public boolean canBeRiddenInWater() {
        return true;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.getDimensions(this.getPose()), 1.0f)).add(0.0, 2.0, 0.0);
    }

    public void kill() {
        this.dropEquipment();
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() != null && source.getEntity().isCrouching() && !this.isVehicle()) {
            this.dropEquipment();
            if (!this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    public boolean causeFallDamage(float p_150347_, float p_150348_, DamageSource p_150349_) {
        if (p_150347_ >= 3.0f && !this.level().isClientSide) {
            this.level().explode(null, this.getX(), this.getY(), this.getZ(), 10.0f, true, Level.ExplosionInteraction.TNT);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return super.causeFallDamage(p_150347_, p_150348_, p_150349_);
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getItems().size(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || EnchantmentHelper.hasVanishingCurse((ItemStack)itemstack)) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        compound.put("InventoryCustom", (Tag)this.inventory.createTag((HolderLookup.Provider)this.registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        ListTag inventoryCustom = compound.getList("InventoryCustom", 15);
        this.inventory.fromTag(inventoryCustom, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        super.interact(player, hand);
        InteractionResult result = InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        if (!this.level().isClientSide) {
            if (player.isCrouching()) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.CONSUME;
            }
            player.startRiding((Entity)this);
            return InteractionResult.CONSUME;
        }
        return result;
    }

    @Override
    public void tick() {
        super.tick();
        this.slowDownLander();
    }

    public void beepWarningSound() {
        if (this.level().isClientSide()) {
            playBeep.accept(this);
        }
    }

    public void boostSound() {
        if (this.level().isClientSide()) {
            playBoost.accept(this);
        }
    }

    public Player getFirstPlayerPassenger() {
        if (this.getPassengers().isEmpty()) {
            return null;
        }
        Object e = this.getPassengers().getFirst();
        if (e instanceof Player) {
            Player player = (Player)e;
            return player;
        }
        return null;
    }

    public void slowDownLander() {
        Player player = this.getFirstPlayerPassenger();
        if (player != null && KeyVariables.isHoldingJump(player)) {
            Vec3 vec = this.getDeltaMovement();
            if (!this.onGround() && !this.isEyeInFluid(FluidTags.WATER)) {
                if (vec.y() < -0.05) {
                    this.setDeltaMovement(vec.x(), vec.y() * 0.85, vec.z());
                }
                this.fallDistance = (float)(vec.y() * -1.0 * 4.5);
                if (this.level() instanceof ServerLevel) {
                    for (ServerPlayer p : ((ServerLevel)player.level()).getServer().getPlayerList().getPlayers()) {
                        ((ServerLevel)this.level()).sendParticles(p, (ParticleOptions)ParticleTypes.SPIT, true, this.getX(), this.getY() - 0.3, this.getZ(), 3, 0.1, 0.1, 0.1, 0.001);
                    }
                }
            }
        }
    }

    public void openCustomInventoryScreen(Player player) {
        MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buf) {
            }

            public Component getDisplayName() {
                return Component.translatable((String)"container.entity.stellaris.lander");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
                RegistryFriendlyByteBuf packetBuffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), player.registryAccess());
                packetBuffer.writeVarInt(LanderEntity.this.getId());
                return new LanderMenu(id, playerInv, (Container)LanderEntity.this.inventory);
            }
        });
    }

    public Container getInventory() {
        return this.inventory;
    }
}

