/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities;

import com.google.common.collect.Sets;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.RocketModel;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data_components.RocketComponent;
import com.st0x0ef.stellaris.common.entities.IVehicleEntity;
import com.st0x0ef.stellaris.common.items.upgrade.RocketUpgradeItem;
import com.st0x0ef.stellaris.common.menus.RocketMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncRocketComponentPacket;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityData;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.SoundRegistry;
import com.st0x0ef.stellaris.common.rocket_upgrade.FuelType;
import com.st0x0ef.stellaris.common.rocket_upgrade.ModelUpgrade;
import com.st0x0ef.stellaris.common.rocket_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.rocket_upgrade.RocketUpgrade;
import com.st0x0ef.stellaris.common.rocket_upgrade.SkinUpgrade;
import com.st0x0ef.stellaris.common.rocket_upgrade.TankUpgrade;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RocketEntity
extends IVehicleEntity
implements HasCustomInventoryScreen,
ContainerListener {
    public int START_TIMER;
    public boolean ROCKET_START;
    public int FUEL;
    public SkinUpgrade SKIN_UPGRADE;
    public ModelUpgrade MODEL_UPGRADE;
    public MotorUpgrade MOTOR_UPGRADE;
    public TankUpgrade TANK_UPGRADE;
    private Item currentFuelItem;
    protected SimpleContainer inventory;
    public RocketComponent rocketComponent;
    private Player lastPlayer;

    public RocketEntity(EntityType<?> entityType, Level level) {
        this(entityType, level, SkinUpgrade.getBasic());
    }

    protected RocketEntity(EntityType<?> entityType, Level level, SkinUpgrade skinUpgrade) {
        super(entityType, level);
        this.SKIN_UPGRADE = skinUpgrade;
        this.MODEL_UPGRADE = ModelUpgrade.getBasic();
        this.MOTOR_UPGRADE = MotorUpgrade.getBasic();
        this.TANK_UPGRADE = TankUpgrade.getBasic();
        this.START_TIMER = 0;
        this.ROCKET_START = false;
        this.FUEL = 0;
        this.currentFuelItem = (Item)ItemsRegistry.FUEL_BUCKET.get();
        this.rocketComponent = new RocketComponent(this.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(this.MODEL_UPGRADE.getModel().toString()), this.currentFuelItem.toString(), this.FUEL, this.TANK_UPGRADE.getTankCapacity());
        this.inventory = new SimpleContainer(14);
    }

    @Override
    public void tick() {
        super.tick();
        this.rocketExplosion();
        this.burnEntities();
        this.checkContainer();
        if (this.ROCKET_START) {
            this.spawnParticle();
            this.startTimerAndFlyMovement();
        }
        if (this.getY() > 600.0) {
            this.openPlanetMenu(this.getFirstPlayerPassenger());
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("InventoryCustom", (Tag)this.inventory.createTag((HolderLookup.Provider)this.registryAccess()));
        compound.putInt("fuel", this.FUEL);
        if (this.FUEL != 0 && this.currentFuelItem != null) {
            if (FuelType.Type.getTypeBasedOnItem(this.currentFuelItem) != null) {
                compound.putString("currentFuelItemType", FuelType.Type.getTypeBasedOnItem(this.currentFuelItem).getSerializedName());
            } else if (FuelType.Type.Radioactive.getTypeBasedOnItem(this.currentFuelItem) != null) {
                compound.putString("currentFuelItemType", FuelType.Type.Radioactive.getTypeBasedOnItem(this.currentFuelItem).getSerializedName());
            }
        }
        ListTag listTag = new ListTag();
        for (int i = 1; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemStack = this.inventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)(i - 1));
            listTag.add((Object)itemStack.save((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag));
        }
        compound.put("Items", (Tag)listTag);
        compound.putString("model", this.MODEL_UPGRADE.getModel().toString());
        compound.putString("skin", this.SKIN_UPGRADE.getRocketSkinLocation().toString());
        compound.putString("motor", this.MOTOR_UPGRADE.getFuelType().getSerializedName());
        compound.putInt("tank", this.TANK_UPGRADE.getTankCapacity());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ListTag inventoryCustom = compound.getList("InventoryCustom", 14);
        this.inventory.fromTag(inventoryCustom, (HolderLookup.Provider)this.registryAccess());
        this.FUEL = compound.getInt("fuel");
        if (this.FUEL != 0) {
            this.currentFuelItem = FuelType.getItemBasedOnTypeName(compound.getString("currentFuelItemType"));
        }
        ListTag listTag = compound.getList("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.getCompound(i);
            int j = compoundTag.getByte("Slot") & 0xFF;
            if (j >= this.inventory.getContainerSize() - 1) continue;
            this.inventory.setItem(j + 1, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag).orElse(ItemStack.EMPTY));
        }
        this.MODEL_UPGRADE = new ModelUpgrade(RocketModel.fromString(compound.getString("model")));
        this.SKIN_UPGRADE = new SkinUpgrade(new ResourceLocation(compound.getString("skin")));
        this.MOTOR_UPGRADE = new MotorUpgrade(FuelType.Type.fromString(compound.getString("motor")));
        this.TANK_UPGRADE = new TankUpgrade(compound.getInt("tank"));
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void push(Entity entity) {
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        super.interact(player, hand);
        InteractionResult result = InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        if (!this.level().isClientSide) {
            if (player.isCrouching()) {
                if (!this.tryFillUpRocket(player.getMainHandItem().getItem())) {
                    this.openCustomInventoryScreen(player);
                }
                return InteractionResult.CONSUME;
            }
            this.doPlayerRide(player);
            return InteractionResult.CONSUME;
        }
        return result;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.getDimensions(this.getPose()), 1.0f)).subtract(0.0, 3.15, 0.0);
    }

    public void openCustomInventoryScreen(Player player) {
        this.lastPlayer = player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(FriendlyByteBuf packetByteBuf) {
                    packetByteBuf.writeVarInt(RocketEntity.this.getId());
                }

                public Component getDisplayName() {
                    return Component.literal((String)"Rocket");
                }

                public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeInt(RocketEntity.this.FUEL);
                    packetBuffer.writeVarInt(RocketEntity.this.getId());
                    return new RocketMenu(syncId, inv, (Container)RocketEntity.this.inventory, RocketEntity.this.getId());
                }
            });
        }
    }

    public void kill() {
        this.dropEquipment();
        this.spawnRocketItem();
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity sourceEntity = source.getEntity();
        if (sourceEntity != null && sourceEntity.isCrouching() && !this.isVehicle()) {
            this.spawnRocketItem();
            this.dropEquipment();
            if (!this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        Vec3[] avector3d = new Vec3[]{RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)livingEntity.getYRot()), RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(livingEntity.getYRot() - 22.5f)), RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(livingEntity.getYRot() + 22.5f)), RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(livingEntity.getYRot() - 45.0f)), RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(livingEntity.getYRot() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.getBoundingBox().maxY;
        double d1 = this.getBoundingBox().minY - 0.5;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Vec3 vector3d : avector3d) {
            blockpos$mutable.set(this.getX() + vector3d.x, d0, this.getZ() + vector3d.z);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.immutable());
                blockpos$mutable.move(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.level().getFluidState(blockpos).is(FluidTags.LAVA) || !DismountHelper.isBlockFloorValid((double)(d3 = this.level().getBlockFloorHeight(blockpos)))) continue;
            Vec3 vector3d1 = Vec3.upFromBottomCenterOf((Vec3i)blockpos, (double)d3);
            for (Pose pose : livingEntity.getDismountPoses()) {
                if (!DismountHelper.isBlockFloorValid((double)this.level().getBlockFloorHeight(blockpos))) continue;
                livingEntity.setPose(pose);
                return vector3d1;
            }
        }
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void spawnParticle() {
        block4: {
            Level level = this.level();
            if (!(level instanceof ServerLevel)) break block4;
            ServerLevel level2 = (ServerLevel)level;
            Vec3 vec = this.getDeltaMovement();
            if (this.START_TIMER == 200) {
                for (ServerPlayer player : level2.getServer().getPlayerList().getPlayers()) {
                    level2.sendParticles(player, (ParticleOptions)ParticleTypes.FLAME, true, this.getX() - vec.x, this.getY() - vec.y - 2.2, this.getZ() - vec.z, 20, 0.1, 0.1, 0.1, 0.001);
                    level2.sendParticles(player, (ParticleOptions)ParticleTypes.FLAME, true, this.getX() - vec.x, this.getY() - vec.y - 3.2, this.getZ() - vec.z, 10, 0.1, 0.1, 0.1, 0.04);
                }
            } else {
                for (ServerPlayer player : level2.getServer().getPlayerList().getPlayers()) {
                    level2.sendParticles(player, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, this.getX() - vec.x, this.getY() - vec.y - 0.1, this.getZ() - vec.z, 6, 0.1, 0.1, 0.1, 0.023);
                }
            }
        }
    }

    public void startRocket() {
        Player player = (Player)this.getFirstPassenger();
        if (player != null) {
            if (this.FUEL > 0 || player.isCreative()) {
                if (!this.ROCKET_START) {
                    this.ROCKET_START = true;
                    this.level().playSound(null, (Entity)this, (SoundEvent)SoundRegistry.ROCKET_SOUND.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.stellaris.rocket.fuel", (Object[])new Object[]{this.MOTOR_UPGRADE.getFuelType().getSerializedName()}), true);
            }
        }
    }

    public void startTimerAndFlyMovement() {
        if (this.START_TIMER < 200) {
            ++this.START_TIMER;
        }
        if (this.START_TIMER == 200) {
            if (this.getDeltaMovement().y < this.getRocketSpeed() - 0.1) {
                this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.1, this.getDeltaMovement().z);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().x, this.getRocketSpeed(), this.getDeltaMovement().z);
            }
        }
    }

    private void destroyRocket(boolean explode) {
        if (!this.level().isClientSide) {
            if (explode) {
                this.level().explode((Entity)this, this.getX(), this.getBoundingBox().maxY, this.getZ(), 10.0f, true, Level.ExplosionInteraction.TNT);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void rocketExplosion() {
        if (this.START_TIMER == 200 && this.getDeltaMovement().y < -0.07) {
            this.destroyRocket(true);
        }
    }

    public Player getFirstPlayerPassenger() {
        Object e;
        if (!this.getPassengers().isEmpty() && (e = this.getPassengers().getFirst()) instanceof Player) {
            Player player = (Player)e;
            return player;
        }
        return null;
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getItems().size(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || EnchantmentHelper.hasVanishingCurse((ItemStack)itemstack)) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    public ItemStack getRocketItem() {
        ItemStack itemStack = new ItemStack((ItemLike)ItemsRegistry.ROCKET.get(), 1);
        this.rocketComponent = new RocketComponent(this.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(this.MODEL_UPGRADE.getModel().toString()), this.currentFuelItem.toString(), this.FUEL, this.TANK_UPGRADE.getTankCapacity());
        Stellaris.LOG.error(this.MODEL_UPGRADE.getModel().getSerializedName());
        itemStack.set((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get(), (Object)this.rocketComponent);
        return itemStack;
    }

    public void containerChanged(Container container) {
    }

    protected void doPlayerRide(Player player) {
        if (!this.level().isClientSide) {
            Vec3 entityPos = player.getPosition(0.0f);
            player.setPosRaw(entityPos.x, entityPos.y + 40.0, entityPos.z);
            player.startRiding((Entity)this);
        }
    }

    private void checkContainer() {
        RocketUpgrade upgrade;
        RocketUpgrade rocketUpgrade;
        RocketUpgradeItem item;
        if (this.level().isClientSide) {
            return;
        }
        Item item2 = this.getInventory().getItem(10).getItem();
        if (item2 instanceof RocketUpgradeItem) {
            item = (RocketUpgradeItem)item2;
            rocketUpgrade = item.getUpgrade();
            if (rocketUpgrade instanceof MotorUpgrade) {
                upgrade = (MotorUpgrade)rocketUpgrade;
                this.MOTOR_UPGRADE = upgrade;
            }
        } else if (this.getInventory().getItem(10).isEmpty()) {
            this.MOTOR_UPGRADE = MotorUpgrade.getBasic();
        }
        upgrade = this.getInventory().getItem(11).getItem();
        if (upgrade instanceof RocketUpgradeItem) {
            item = (RocketUpgradeItem)((Object)upgrade);
            rocketUpgrade = item.getUpgrade();
            if (rocketUpgrade instanceof TankUpgrade) {
                upgrade = (TankUpgrade)rocketUpgrade;
                this.TANK_UPGRADE = upgrade;
            }
        } else if (this.getInventory().getItem(11).isEmpty()) {
            this.TANK_UPGRADE = TankUpgrade.getBasic();
        }
        upgrade = this.getInventory().getItem(12).getItem();
        if (upgrade instanceof RocketUpgradeItem) {
            item = (RocketUpgradeItem)((Object)upgrade);
            rocketUpgrade = item.getUpgrade();
            if (rocketUpgrade instanceof SkinUpgrade) {
                upgrade = (SkinUpgrade)rocketUpgrade;
                this.SKIN_UPGRADE = upgrade;
                if (this.lastPlayer != null) {
                    this.lastPlayer.closeContainer();
                }
                this.changeRocketModelAndSkin();
            }
        } else if (this.getInventory().getItem(12).isEmpty()) {
            this.SKIN_UPGRADE = SkinUpgrade.getBasic();
        }
        upgrade = this.getInventory().getItem(13).getItem();
        if (upgrade instanceof RocketUpgradeItem) {
            item = (RocketUpgradeItem)((Object)upgrade);
            rocketUpgrade = item.getUpgrade();
            if (rocketUpgrade instanceof ModelUpgrade) {
                upgrade = (ModelUpgrade)rocketUpgrade;
                if (this.MODEL_UPGRADE.getModel() != ((ModelUpgrade)upgrade).getModel()) {
                    this.MODEL_UPGRADE = upgrade;
                    if (this.lastPlayer != null) {
                        this.lastPlayer.closeContainer();
                    }
                    this.changeRocketModelAndSkin();
                }
            }
        } else if (this.getInventory().getItem(13).isEmpty()) {
            this.MODEL_UPGRADE = ModelUpgrade.getBasic();
        }
        this.tryFillUpRocket(this.getInventory().getItem(0).getItem());
    }

    public boolean tryFillUpRocket(Item item) {
        if (this.level().isClientSide) {
            return false;
        }
        if (this.FUEL == this.TANK_UPGRADE.getTankCapacity() || item == null) {
            return false;
        }
        if (this.MOTOR_UPGRADE.getFuelType().equals((Object)FuelType.Type.RADIOACTIVE) && FuelType.Type.Radioactive.getTypeBasedOnItem(item) != null && this.canPutFuelBasedOnCurrentFuelItem(item)) {
            this.FUEL += 1000;
            if (this.FUEL > this.TANK_UPGRADE.getTankCapacity()) {
                this.FUEL = this.TANK_UPGRADE.getTankCapacity();
            }
            this.inventory.removeItem(0, 1);
            return true;
        }
        if (FuelType.Type.getTypeBasedOnItem(item) == this.MOTOR_UPGRADE.getFuelType() && this.canPutFuelBasedOnCurrentFuelItem(item)) {
            this.FUEL += 1000;
            if (this.FUEL > this.TANK_UPGRADE.getTankCapacity()) {
                this.FUEL = this.TANK_UPGRADE.getTankCapacity();
            }
            if (this.inventory.removeItem(0, 1).is((Item)ItemsRegistry.FUEL_BUCKET.get())) {
                this.inventory.setItem(1, new ItemStack((ItemLike)Items.BUCKET, this.inventory.getItem(1).getCount() + 1));
            }
            return true;
        }
        return false;
    }

    private boolean canPutFuelBasedOnCurrentFuelItem(Item item) {
        if (this.FUEL == 0) {
            this.currentFuelItem = item;
            return true;
        }
        return this.currentFuelItem == item;
    }

    private void openPlanetMenu(Player player) {
        if (player == null) {
            return;
        }
        if (!((Boolean)player.getEntityData().get(EntityData.DATA_PLANET_MENU_OPEN)).booleanValue()) {
            player.setNoGravity(true);
            player.getVehicle().setNoGravity(true);
            PlanetUtil.openPlanetSelectionMenu(player, false);
            player.getEntityData().set(EntityData.DATA_PLANET_MENU_OPEN, (Object)true);
        }
    }

    public void burnEntities() {
        if (this.START_TIMER == 200) {
            AABB aabb = AABB.ofSize((Vec3)new Vec3(this.getX(), this.getY() - 2.0, this.getZ()), (double)2.0, (double)2.0, (double)2.0);
            List entities = this.getCommandSenderWorld().getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity entity : entities) {
                entity.setRemainingFireTicks(40);
            }
        }
    }

    protected void spawnRocketItem() {
        ItemEntity entityToSpawn = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getRocketItem());
        entityToSpawn.setPickUpDelay(10);
        this.level().addFreshEntity((Entity)entityToSpawn);
    }

    public int getFuel() {
        return this.FUEL;
    }

    public Container getInventory() {
        return this.inventory;
    }

    public double getRocketSpeed() {
        return 0.8;
    }

    public String getFullSkinTexture() {
        String texture = this.SKIN_UPGRADE.getRocketSkinLocation().toString();
        if (this.MODEL_UPGRADE != null) {
            texture = texture.replace("normal", this.MODEL_UPGRADE.getModel().toString());
        }
        return texture;
    }

    public boolean canGoTo(Planet actual, Planet destination) {
        return (float)Mth.abs((int)(actual.distanceFromEarth() - destination.distanceFromEarth())) <= FuelType.getMegametersTraveled(this.rocketComponent.fuel(), FuelType.getItemBasedOnLoacation(new ResourceLocation("stellaris", this.rocketComponent.fuelType())));
    }

    public void syncRocketData(ServerPlayer player) {
        this.rocketComponent = new RocketComponent(this.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(this.MODEL_UPGRADE.getModel().toString()), this.currentFuelItem.toString(), this.FUEL, this.TANK_UPGRADE.getTankCapacity());
        if (!this.level().isClientSide()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncRocketComponentPacket(this.rocketComponent));
        }
    }

    public void changeRocketModelAndSkin() {
        NonNullList itemStacks = this.inventory.getItems();
        Vec3 pos = this.position();
        Player passenger = this.getFirstPlayerPassenger();
        EntityType<? extends RocketEntity> newRocketType = this.getEntityType(this.MODEL_UPGRADE);
        RocketEntity newRocketEntity = new RocketEntity(newRocketType, this.level(), this.SKIN_UPGRADE);
        newRocketEntity.setPos(pos);
        newRocketEntity.MODEL_UPGRADE = this.MODEL_UPGRADE;
        newRocketEntity.SKIN_UPGRADE = this.SKIN_UPGRADE;
        newRocketEntity.MOTOR_UPGRADE = this.MOTOR_UPGRADE;
        newRocketEntity.TANK_UPGRADE = this.TANK_UPGRADE;
        newRocketEntity.FUEL = this.FUEL;
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            if (i != 13 && i != 12) {
                newRocketEntity.inventory.setItem(i, (ItemStack)itemStacks.get(i));
                continue;
            }
            ItemStack itemStack13 = (ItemStack)itemStacks.get(13);
            ItemStack itemStack12 = (ItemStack)itemStacks.get(12);
            newRocketEntity.inventory.setItem(i, new ItemStack((ItemLike)itemStack13.getItem(), itemStack13.getCount() - 1));
            newRocketEntity.inventory.setItem(i, new ItemStack((ItemLike)itemStack12.getItem(), itemStack12.getCount() - 1));
        }
        this.remove(Entity.RemovalReason.DISCARDED);
        newRocketEntity.level().addFreshEntity((Entity)newRocketEntity);
        if (passenger != null) {
            newRocketEntity.doPlayerRide(passenger);
        }
    }

    public EntityType<? extends RocketEntity> getEntityType(ModelUpgrade upgrade) {
        return switch (upgrade.getModel()) {
            default -> throw new MatchException(null, null);
            case RocketModel.TINY -> (EntityType)EntityRegistry.TINY_ROCKET.get();
            case RocketModel.SMALL -> (EntityType)EntityRegistry.SMALL_ROCKET.get();
            case RocketModel.NORMAL -> (EntityType)EntityRegistry.NORMAL_ROCKET.get();
            case RocketModel.BIG -> (EntityType)EntityRegistry.BIG_ROCKET.get();
        };
    }
}

