/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.events;

import com.st0x0ef.stellaris.common.blocks.entities.machines.oxygen.OxygenContainerBlockEntity;
import com.st0x0ef.stellaris.common.items.RadiationItem;
import com.st0x0ef.stellaris.common.oxygen.OxygenManager;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Events {
    private static int tickBeforeNextRadioactiveCheck = 100;

    public static void registerEvents() {
        TickEvent.PLAYER_POST.register(player -> {
            if (tickBeforeNextRadioactiveCheck <= 0 && !Utils.isLivingInJetSuit((LivingEntity)player)) {
                AtomicBoolean addEffect = new AtomicBoolean();
                AtomicInteger level = new AtomicInteger();
                ArrayList items = new ArrayList(player.getInventory().items);
                items.forEach(itemStack -> {
                    Item patt0$temp = itemStack.getItem();
                    if (patt0$temp instanceof RadiationItem) {
                        RadiationItem radioactiveItem = (RadiationItem)patt0$temp;
                        addEffect.set(true);
                        if (level.get() < radioactiveItem.getRadiationLevel()) {
                            level.set(radioactiveItem.getRadiationLevel());
                        }
                    }
                });
                if (addEffect.get()) {
                    if (player.level().isClientSide()) {
                        return;
                    }
                    player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 80));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80));
                }
                tickBeforeNextRadioactiveCheck = 100;
            }
            --tickBeforeNextRadioactiveCheck;
        });
        BlockEvent.BREAK.register((level, pos, state, player, value) -> {
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof OxygenContainerBlockEntity) {
                OxygenContainerBlockEntity oxygenContainer = (OxygenContainerBlockEntity)patt0$temp;
                OxygenManager.removeOxygenBlocksPerLevel(level, oxygenContainer);
            }
            if (PlanetUtil.isPlanet(level.dimension().location())) {
                OxygenManager.distributeOxygenForLevel(level);
            }
            return EventResult.pass();
        });
    }
}

