/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.st0x0ef.stellaris.common.blocks.RocketLaunchPad;
import com.st0x0ef.stellaris.common.data_components.RocketComponent;
import com.st0x0ef.stellaris.common.entities.RocketEntity;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class RocketItem
extends Item {
    public RocketItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        InteractionHand hand = context.getHand();
        ItemStack itemStack = context.getItemInHand();
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        if (state.getBlock() instanceof RocketLaunchPad && ((Boolean)state.getValue((Property)RocketLaunchPad.STAGE)).booleanValue()) {
            BlockPlaceContext blockplacecontext = new BlockPlaceContext(context);
            BlockPos blockpos = blockplacecontext.getClickedPos();
            Vec3 vec3 = Vec3.upFromBottomCenterOf((Vec3i)blockpos, (double)this.getRocketPlaceHigh());
            AABB aabb = ((EntityType)EntityRegistry.NORMAL_ROCKET.get()).getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
            if (level.noCollision(aabb)) {
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                AABB scanAbove = new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
                List entities = player.getCommandSenderWorld().getEntitiesOfClass(Entity.class, scanAbove);
                if (entities.isEmpty()) {
                    RocketEntity rocket = this.getRocket(context.getLevel(), itemStack);
                    rocket.setPos((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5);
                    double d0 = RocketItem.getYOffset((LevelReader)level, pos, true, rocket.getBoundingBox());
                    float f = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 45.0f) / 90.0f)) * 90.0f;
                    rocket.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + d0, (double)pos.getZ() + 0.5, f, 0.0f);
                    rocket.yRotO = rocket.getYRot();
                    level.addFreshEntity((Entity)rocket);
                    this.addRocketInfos(rocket, itemStack);
                    if (!player.getAbilities().instabuild) {
                        player.setItemInHand(hand, ItemStack.EMPTY);
                    }
                    this.rocketPlaceSound(pos, level);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.useOn(context);
    }

    public EntityType<? extends RocketEntity> getEntityType(ItemStack stack) {
        RocketComponent rocketComponent = (RocketComponent)stack.get((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get());
        return switch (rocketComponent.getModel().toString()) {
            case "tiny" -> (EntityType)EntityRegistry.TINY_ROCKET.get();
            case "small" -> (EntityType)EntityRegistry.SMALL_ROCKET.get();
            case "normal" -> (EntityType)EntityRegistry.NORMAL_ROCKET.get();
            case "big" -> (EntityType)EntityRegistry.BIG_ROCKET.get();
            default -> (EntityType)EntityRegistry.TINY_ROCKET.get();
        };
    }

    public RocketEntity getRocket(Level level, ItemStack stack) {
        return new RocketEntity(this.getEntityType(stack), level);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        RocketComponent rocketComponent = (RocketComponent)stack.get((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get());
        if (rocketComponent == null) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.stellaris.rocket.skin", (Object[])new Object[]{rocketComponent.skin()}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.stellaris.rocket.fuel", (Object[])new Object[]{rocketComponent.fuel()}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.stellaris.rocket.model", (Object[])new Object[]{rocketComponent.model().toString()}).withStyle(ChatFormatting.GRAY));
    }

    public float getRocketPlaceHigh() {
        return -0.6f;
    }

    public void rocketPlaceSound(BlockPos pos, Level world) {
        world.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected static double getYOffset(LevelReader reader, BlockPos pos, boolean p_20628_, AABB p_20629_) {
        AABB aabb = new AABB(pos);
        if (p_20628_) {
            aabb = aabb.expandTowards(0.0, -1.0, 0.0);
        }
        Iterable iterable = reader.getCollisions(null, aabb);
        return 1.0 + Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)p_20629_, (Iterable)iterable, (double)(p_20628_ ? -2.0 : -1.0));
    }

    private void addRocketInfos(RocketEntity rocket, ItemStack stack) {
        RocketComponent rocketComponent = (RocketComponent)stack.get((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get());
        rocket.FUEL = rocketComponent.getFuel();
        rocket.MODEL_UPGRADE = rocketComponent.getModelUpgrade();
        rocket.SKIN_UPGRADE = rocketComponent.getSkinUpgrade();
        rocket.MOTOR_UPGRADE = rocketComponent.getMotorUpgrade();
        rocket.TANK_UPGRADE = rocketComponent.getTankUpgrade();
    }
}

