/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.oxygen;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankHelper;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import dev.architectury.platform.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class OxygenTankItem
extends Item {
    private final long capacity;

    public OxygenTankItem(Item.Properties properties, long capacity) {
        super(properties);
        this.capacity = Platform.isFabric() ? FluidTankHelper.convertFromMb(capacity) : capacity;
    }

    public static void setStoredOxygen(ItemStack stack, long amount) {
        stack.set((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get(), (Object)Mth.clamp((long)amount, (long)0L, (long)((OxygenTankItem)stack.getItem()).getCapacity()));
    }

    public static long getStoredOxygen(ItemStack stack) {
        return stack.has((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get()) ? (Long)stack.get((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get()) : 0L;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (stack.has((DataComponentType)DataComponentsRegistry.STORED_OXYGEN_COMPONENT.get())) {
            tooltip.add((Component)Component.translatable((String)"tooltip.item.stellaris.oxygen_tank", (Object[])new Object[]{OxygenTankItem.getStoredOxygen(stack), this.capacity}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        long storedOxygen = OxygenTankItem.getStoredOxygen(stack);
        return (int)Mth.clamp((long)((13L + storedOxygen * 13L) / this.capacity), (long)0L, (long)13L);
    }

    public int getBarColor(ItemStack stack) {
        return 11003629;
    }

    public long getCapacity() {
        return this.capacity;
    }
}

