/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FuelRefineryBlockEntity;
import com.st0x0ef.stellaris.common.menus.BaseContainer;
import com.st0x0ef.stellaris.common.menus.slot.FluidContainerSlot;
import com.st0x0ef.stellaris.common.menus.slot.ResultSlot;
import com.st0x0ef.stellaris.common.network.packets.SyncWidgetsTanksPacket;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public class FuelRefineryMenu
extends BaseContainer {
    private final Container container;
    private final FuelRefineryBlockEntity blockEntity;

    public static FuelRefineryMenu create(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        FuelRefineryBlockEntity blockEntity = (FuelRefineryBlockEntity)inventory.player.level().getBlockEntity(buf.readBlockPos());
        return new FuelRefineryMenu(containerId, inventory, (Container)new SimpleContainer(4), blockEntity);
    }

    public FuelRefineryMenu(int containerId, Inventory inventory, Container container, FuelRefineryBlockEntity blockEntity) {
        super((MenuType)MenuTypesRegistry.FUEL_REFINERY.get(), containerId, 4, inventory, 18);
        this.container = container;
        this.blockEntity = blockEntity;
        this.addSlot(new FluidContainerSlot(container, 0, 12, 22, false, false));
        this.addSlot(new ResultSlot(container, 1, 12, 52));
        this.addSlot(new FluidContainerSlot(container, 2, 127, 22, true, true));
        this.addSlot(new ResultSlot(container, 3, 127, 52));
    }

    @Override
    public boolean stillValid(Player player) {
        if (!player.isLocalPlayer()) {
            this.syncWidgets((ServerPlayer)player);
        }
        return this.container.stillValid(player);
    }

    public FuelRefineryBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public void syncWidgets(ServerPlayer player) {
        if (!player.level().isClientSide()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncWidgetsTanksPacket(new long[]{this.blockEntity.getIngredientTank().getAmount(), this.blockEntity.getResultTank().getAmount()}, new ResourceLocation[]{this.blockEntity.getIngredientTank().getStack().getFluid().arch$registryName(), this.blockEntity.getResultTank().getStack().getFluid().arch$registryName()}));
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncWidgetsTanksPacket(new long[]{this.blockEntity.getWrappedEnergyContainer().getStoredEnergy()}));
        }
    }
}

