/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.SolarPanelEntity;
import com.st0x0ef.stellaris.common.network.packets.SyncWidgetsTanksPacket;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import com.st0x0ef.stellaris.platform.systems.energy.EnergyContainer;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SolarPanelMenu
extends AbstractContainerMenu {
    private final Container inventory;
    private final SolarPanelEntity entity;

    public static SolarPanelMenu create(int syncId, Inventory inventory, FriendlyByteBuf data) {
        SolarPanelEntity entity = (SolarPanelEntity)inventory.player.level().getBlockEntity(data.readBlockPos());
        return new SolarPanelMenu(syncId, inventory, (Container)new SimpleContainer(new ItemStack[0]), entity);
    }

    public SolarPanelMenu(int syncId, Inventory playerInventory, Container container, SolarPanelEntity entity) {
        super((MenuType)MenuTypesRegistry.SOLAR_PANEL_MENU.get(), syncId);
        this.inventory = container;
        this.entity = entity;
        this.addPlayerHotbar(playerInventory);
        this.addPlayerInventory(playerInventory);
    }

    public SolarPanelEntity getBlockEntity() {
        return this.entity;
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        if (!player.isLocalPlayer()) {
            this.syncBattery((ServerPlayer)player);
        }
        return this.inventory.stillValid(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18 + 62));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 204));
        }
    }

    public EnergyContainer getEnergyContainer() {
        return this.entity.getWrappedEnergyContainer();
    }

    public void syncBattery(ServerPlayer player) {
        if (!player.level().isClientSide()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncWidgetsTanksPacket(new long[]{this.getEnergyContainer().getStoredEnergy()}));
        }
    }
}

