/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus.slot;

import com.st0x0ef.stellaris.common.armors.JetSuit;
import com.st0x0ef.stellaris.common.items.oxygen.OxygenTankItem;
import dev.architectury.hooks.fluid.FluidBucketHooks;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluids;

public class FluidContainerSlot
extends Slot {
    private final boolean emptyOnly;
    private final boolean allowTanks;

    public FluidContainerSlot(Container container, int slot, int x, int y, boolean emptyOnly, boolean allowTanks) {
        super(container, slot, x, y);
        this.emptyOnly = emptyOnly;
        this.allowTanks = allowTanks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayPlace(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BucketItem) {
            BucketItem item2 = (BucketItem)item;
            if (!this.emptyOnly) return true;
            if (FluidBucketHooks.getFluid((BucketItem)item2).isSame(Fluids.EMPTY)) return true;
        }
        if (this.allowTanks) {
            if (stack.getItem() instanceof OxygenTankItem) return true;
        }
        if (!this.allowTanks) return false;
        if (!(stack.getItem() instanceof JetSuit.Suit)) return false;
        return true;
    }

    public int getMaxStackSize() {
        return 1;
    }
}

