/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.armors.JetSuit;
import com.st0x0ef.stellaris.common.entities.RocketEntity;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.network.NetworkRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class KeyHandlerPacket
implements CustomPacketPayload {
    public final String key;
    public final boolean condition;
    public static final StreamCodec<RegistryFriendlyByteBuf, KeyHandlerPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, KeyHandlerPacket>(){

        @NotNull
        public KeyHandlerPacket decode(RegistryFriendlyByteBuf buf) {
            return new KeyHandlerPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, KeyHandlerPacket packet) {
            buf.writeUtf(packet.key);
            buf.writeBoolean(packet.condition);
        }
    };

    public KeyHandlerPacket(String key, boolean condition) {
        this.key = key;
        this.condition = condition;
    }

    public KeyHandlerPacket(RegistryFriendlyByteBuf buffer) {
        this.key = buffer.readUtf();
        this.condition = buffer.readBoolean();
    }

    public static void handle(KeyHandlerPacket packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        KeyHandlerPacket keyHandler = packet;
        context.queue(() -> {
            switch (keyHandler.key) {
                case "key_up": {
                    KeyVariables.KEY_UP.put(player.getUUID(), keyHandler.condition);
                    break;
                }
                case "key_down": {
                    KeyVariables.KEY_DOWN.put(player.getUUID(), keyHandler.condition);
                    break;
                }
                case "key_right": {
                    KeyVariables.KEY_RIGHT.put(player.getUUID(), keyHandler.condition);
                    break;
                }
                case "key_left": {
                    KeyVariables.KEY_LEFT.put(player.getUUID(), keyHandler.condition);
                    break;
                }
                case "switch_jet_suit_mode": {
                    if (!Utils.isLivingInJetSuit((LivingEntity)player)) break;
                    ItemStack itemStack = player.getItemBySlot(EquipmentSlot.CHEST);
                    JetSuit.Suit item = (JetSuit.Suit)itemStack.getItem();
                    item.switchJetSuitMode(player, itemStack);
                    break;
                }
                case "rocket_start": {
                    Entity patt0$temp = player.getVehicle();
                    if (!(patt0$temp instanceof RocketEntity)) break;
                    RocketEntity rocketEntity = (RocketEntity)patt0$temp;
                    rocketEntity.startRocket();
                    break;
                }
                case "key_jump": {
                    KeyVariables.KEY_JUMP.put(player.getUUID(), keyHandler.condition);
                    break;
                }
                case "freeze_planet_menu": {
                    AbstractContainerMenu patt1$temp = player.containerMenu;
                    if (!(patt1$temp instanceof PlanetSelectionMenu)) break;
                    PlanetSelectionMenu menu = (PlanetSelectionMenu)patt1$temp;
                    menu.switchFreezeGui();
                    break;
                }
                default: {
                    Stellaris.LOG.error("unknown key action {}", (Object)keyHandler.key);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return NetworkRegistry.KEY_HANDLER_ID;
    }
}

