/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.st0x0ef.stellaris.common.data_components.RocketComponent;
import com.st0x0ef.stellaris.common.menus.RocketMenu;
import com.st0x0ef.stellaris.common.network.NetworkRegistry;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class SyncRocketComponentPacket
implements CustomPacketPayload {
    private final RocketComponent component;
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncRocketComponentPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SyncRocketComponentPacket>(){

        @NotNull
        public SyncRocketComponentPacket decode(RegistryFriendlyByteBuf buf) {
            return new SyncRocketComponentPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, SyncRocketComponentPacket packet) {
            packet.component.toNetwork(buf);
        }
    };

    public SyncRocketComponentPacket(RegistryFriendlyByteBuf buffer) {
        this(RocketComponent.fromNetwork(buffer));
    }

    public SyncRocketComponentPacket(RocketComponent component) {
        this.component = component;
    }

    public static void handle(SyncRocketComponentPacket packet, NetworkManager.PacketContext context) {
        LocalPlayer player = (LocalPlayer)context.getPlayer();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof RocketMenu) {
            RocketMenu menu = (RocketMenu)abstractContainerMenu;
            menu.getRocket().rocketComponent = packet.component;
            menu.getRocket().MODEL_UPGRADE = packet.component.getModelUpgrade();
            menu.getRocket().SKIN_UPGRADE = packet.component.getSkinUpgrade();
            menu.getRocket().TANK_UPGRADE = packet.component.getTankUpgrade();
            menu.getRocket().MOTOR_UPGRADE = packet.component.getMotorUpgrade();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return NetworkRegistry.SYNC_ROCKET_COMPONENT_ID;
    }
}

