/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTank;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FuelRefineryBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.WaterSeparatorBlockEntity;
import com.st0x0ef.stellaris.common.menus.CoalGeneratorMenu;
import com.st0x0ef.stellaris.common.menus.FuelRefineryMenu;
import com.st0x0ef.stellaris.common.menus.OxygenDistributorMenu;
import com.st0x0ef.stellaris.common.menus.RadioactiveGeneratorMenu;
import com.st0x0ef.stellaris.common.menus.SolarPanelMenu;
import com.st0x0ef.stellaris.common.menus.WaterSeparatorMenu;
import com.st0x0ef.stellaris.common.network.NetworkRegistry;
import dev.architectury.networking.NetworkManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.NotNull;

public class SyncWidgetsTanksPacket
implements CustomPacketPayload {
    private final long[] component;
    private final ResourceLocation[] locations;
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncWidgetsTanksPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SyncWidgetsTanksPacket>(){

        @NotNull
        public SyncWidgetsTanksPacket decode(RegistryFriendlyByteBuf buf) {
            return new SyncWidgetsTanksPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, SyncWidgetsTanksPacket packet) {
            buf.writeLongArray(packet.component);
            buf.writeInt(packet.locations.length);
            for (ResourceLocation location : packet.locations) {
                buf.writeResourceLocation(location);
            }
        }
    };

    public SyncWidgetsTanksPacket(RegistryFriendlyByteBuf buffer) {
        this.component = buffer.readLongArray();
        int length = buffer.readInt();
        this.locations = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            this.locations[i] = buffer.readResourceLocation();
        }
    }

    public SyncWidgetsTanksPacket(long[] component) {
        this(component, new ResourceLocation[0]);
    }

    public SyncWidgetsTanksPacket(long[] values, ResourceLocation[] locations) {
        this.component = values;
        this.locations = locations;
    }

    public static void handle(SyncWidgetsTanksPacket syncWidgetsTanks, NetworkManager.PacketContext context) {
        if (context.getEnv() != Dist.CLIENT) {
            return;
        }
        LocalPlayer player = (LocalPlayer)context.getPlayer();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        Objects.requireNonNull(abstractContainerMenu);
        AbstractContainerMenu abstractContainerMenu2 = abstractContainerMenu;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WaterSeparatorMenu.class, FuelRefineryMenu.class, SolarPanelMenu.class, CoalGeneratorMenu.class, RadioactiveGeneratorMenu.class, OxygenDistributorMenu.class}, (Object)abstractContainerMenu2, n)) {
            case 0: {
                WaterSeparatorMenu menu = (WaterSeparatorMenu)abstractContainerMenu2;
                WaterSeparatorBlockEntity blockEntity = menu.getBlockEntity();
                if (syncWidgetsTanks.component.length == 2 && syncWidgetsTanks.locations.length == 2) {
                    ((FluidTank)blockEntity.resultTanks.getFirst()).setFluid((Fluid)BuiltInRegistries.FLUID.get(syncWidgetsTanks.locations[0]), syncWidgetsTanks.component[0]);
                    ((FluidTank)blockEntity.resultTanks.getLast()).setFluid((Fluid)BuiltInRegistries.FLUID.get(syncWidgetsTanks.locations[1]), syncWidgetsTanks.component[1]);
                    break;
                }
                if (syncWidgetsTanks.component.length == 1 && syncWidgetsTanks.locations.length == 1) {
                    blockEntity.ingredientTank.setFluid((Fluid)BuiltInRegistries.FLUID.get(syncWidgetsTanks.locations[0]), syncWidgetsTanks.component[0]);
                    break;
                }
                if (syncWidgetsTanks.component.length != 3) break;
                blockEntity.getWrappedEnergyContainer().setEnergy(syncWidgetsTanks.component[0]);
                break;
            }
            case 1: {
                FuelRefineryMenu menu = (FuelRefineryMenu)abstractContainerMenu2;
                FuelRefineryBlockEntity blockEntity = menu.getBlockEntity();
                if (syncWidgetsTanks.component.length == 2 && syncWidgetsTanks.locations.length == 2) {
                    blockEntity.getIngredientTank().setFluid((Fluid)BuiltInRegistries.FLUID.get(syncWidgetsTanks.locations[0]), syncWidgetsTanks.component[0]);
                    blockEntity.getResultTank().setFluid((Fluid)BuiltInRegistries.FLUID.get(syncWidgetsTanks.locations[1]), syncWidgetsTanks.component[1]);
                    break;
                }
                if (syncWidgetsTanks.component.length != 1) break;
                blockEntity.getWrappedEnergyContainer().setEnergy(syncWidgetsTanks.component[0]);
                break;
            }
            case 2: {
                SolarPanelMenu menu = (SolarPanelMenu)abstractContainerMenu2;
                menu.getEnergyContainer().setEnergy(syncWidgetsTanks.component[0]);
                break;
            }
            case 3: {
                CoalGeneratorMenu menu = (CoalGeneratorMenu)abstractContainerMenu2;
                menu.getBlockEntity().getWrappedEnergyContainer().setEnergy(syncWidgetsTanks.component[0]);
                break;
            }
            case 4: {
                RadioactiveGeneratorMenu menu = (RadioactiveGeneratorMenu)abstractContainerMenu2;
                menu.getBlockEntity().getWrappedEnergyContainer().setEnergy(syncWidgetsTanks.component[0]);
                break;
            }
            case 5: {
                OxygenDistributorMenu menu = (OxygenDistributorMenu)abstractContainerMenu2;
                menu.getBlockEntity().getWrappedEnergyContainer().setEnergy(syncWidgetsTanks.component[0]);
                break;
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return NetworkRegistry.SYNC_FLUID_TANKS_ID;
    }
}

