/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.st0x0ef.stellaris.common.blocks.entities.machines.oxygen.OxygenContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.oxygen.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.blocks.entities.machines.oxygen.OxygenPropagatorBlockEntity;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class OxygenManager {
    private static final Map<Level, List<OxygenContainerBlockEntity>> oxygenBlocksPerLevel = new HashMap<Level, List<OxygenContainerBlockEntity>>();
    private static final Map<Level, List<Integer[]>> oxygenInformationsPerLevel = new HashMap<Level, List<Integer[]>>();

    public static void distributeOxygenForLevel(Level level) {
        if (!PlanetUtil.getPlanet(level.dimension().location()).oxygen()) {
            if (!oxygenInformationsPerLevel.containsKey(level)) {
                oxygenInformationsPerLevel.put(level, new ArrayList());
            }
            if (!oxygenBlocksPerLevel.containsKey(level)) {
                oxygenBlocksPerLevel.put(level, new ArrayList());
            }
        }
        if (oxygenInformationsPerLevel.get(level) == null) {
            return;
        }
        oxygenInformationsPerLevel.get(level).clear();
        oxygenBlocksPerLevel.get(level).forEach(container -> {
            if (container instanceof OxygenDistributorBlockEntity) {
                OxygenDistributorBlockEntity distributor = (OxygenDistributorBlockEntity)container;
                OxygenManager.spread(level, distributor.getBlockPos(), false);
            } else if (container instanceof OxygenPropagatorBlockEntity) {
                OxygenPropagatorBlockEntity propagator = (OxygenPropagatorBlockEntity)container;
                OxygenManager.spread(level, propagator.getBlockPos(), true);
            }
        });
        OxygenManager.removeUnclosedRoom(level);
    }

    public static void spread(Level level, BlockPos oxygenBlockPos, boolean isPropagator) {
        ArrayList<Integer[]> unverified = new ArrayList<Integer[]>();
        if (isPropagator) {
            AtomicBoolean stop = new AtomicBoolean();
            oxygenBlocksPerLevel.get(level).forEach(oxygenBlock -> {
                if (Mth.abs((int)(oxygenBlockPos.getX() - oxygenBlock.getBlockPosition().getX())) < 16 && Mth.abs((int)(oxygenBlockPos.getY() - oxygenBlock.getBlockPosition().getY())) < 16 && Mth.abs((int)(oxygenBlockPos.getZ() - oxygenBlock.getBlockPosition().getZ())) < 16 && !stop.get()) {
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX() + 1, oxygenBlockPos.getY(), oxygenBlockPos.getZ()});
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX() - 1, oxygenBlockPos.getY(), oxygenBlockPos.getZ()});
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY() + 1, oxygenBlockPos.getZ()});
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY() - 1, oxygenBlockPos.getZ()});
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY(), oxygenBlockPos.getZ() + 1});
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY(), oxygenBlockPos.getZ() - 1});
                    stop.set(true);
                }
            });
        } else {
            unverified.add(new Integer[]{0, oxygenBlockPos.getX() + 1, oxygenBlockPos.getY(), oxygenBlockPos.getZ()});
            unverified.add(new Integer[]{0, oxygenBlockPos.getX() - 1, oxygenBlockPos.getY(), oxygenBlockPos.getZ()});
            unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY() + 1, oxygenBlockPos.getZ()});
            unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY() - 1, oxygenBlockPos.getZ()});
            unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY(), oxygenBlockPos.getZ() + 1});
            unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY(), oxygenBlockPos.getZ() - 1});
        }
        while (!unverified.isEmpty()) {
            Integer[] base = (Integer[])unverified.getFirst();
            BlockPos basePos = new BlockPos(base[1].intValue(), base[2].intValue(), base[3].intValue());
            if (Mth.abs((int)(oxygenBlockPos.getX() - basePos.getX())) < 16 && Mth.abs((int)(oxygenBlockPos.getY() - basePos.getY())) < 16 && Mth.abs((int)(oxygenBlockPos.getZ() - basePos.getZ())) < 16) {
                if (oxygenInformationsPerLevel.get(level).contains(base)) {
                    oxygenInformationsPerLevel.get(level).remove(base);
                    unverified.remove(base);
                    base[0] = 1;
                    oxygenInformationsPerLevel.get(level).add(base);
                    continue;
                }
                if (level.isEmptyBlock(basePos.east()) && !OxygenManager.hasOxygenAt(level, basePos.east())) {
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX() + 1, oxygenBlockPos.getY(), oxygenBlockPos.getZ()});
                }
                if (level.isEmptyBlock(basePos.west()) && !OxygenManager.hasOxygenAt(level, basePos.west())) {
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX() - 1, oxygenBlockPos.getY(), oxygenBlockPos.getZ()});
                }
                if (level.isEmptyBlock(basePos.above()) && !OxygenManager.hasOxygenAt(level, basePos.above())) {
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY() + 1, oxygenBlockPos.getZ()});
                }
                if (level.isEmptyBlock(basePos.below()) && !OxygenManager.hasOxygenAt(level, basePos.below())) {
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY() - 1, oxygenBlockPos.getZ()});
                }
                if (level.isEmptyBlock(basePos.south()) && !OxygenManager.hasOxygenAt(level, basePos.south())) {
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY(), oxygenBlockPos.getZ() + 1});
                }
                if (level.isEmptyBlock(basePos.north()) && !OxygenManager.hasOxygenAt(level, basePos.north())) {
                    unverified.add(new Integer[]{0, oxygenBlockPos.getX(), oxygenBlockPos.getY(), oxygenBlockPos.getZ() - 1});
                }
                unverified.remove(base);
                base[0] = 1;
                oxygenInformationsPerLevel.get(level).add(base);
                continue;
            }
            unverified.remove(base);
        }
    }

    public static void removeUnclosedRoom(Level level) {
        ArrayList newOxygenInfo = new ArrayList();
        AtomicBoolean stop = new AtomicBoolean();
        while (!stop.get()) {
            ArrayList newOxygenInfoCopy = new ArrayList(newOxygenInfo);
            oxygenInformationsPerLevel.get(level).forEach(oxygenData -> {
                if (oxygenData[0] == 0) {
                    BlockPos basePos = new BlockPos(oxygenData[1].intValue(), oxygenData[2].intValue(), oxygenData[3].intValue());
                    if (level.isEmptyBlock(basePos.east())) {
                        oxygenInformationsPerLevel.get(level).set(oxygenInformationsPerLevel.get(level).indexOf(new Integer[]{1, basePos.getX() + 1, basePos.getY(), basePos.getZ()}), new Integer[]{0, basePos.getX() + 1, basePos.getY(), basePos.getZ()});
                    }
                    if (level.isEmptyBlock(basePos.west())) {
                        oxygenInformationsPerLevel.get(level).set(oxygenInformationsPerLevel.get(level).indexOf(new Integer[]{1, basePos.getX() - 1, basePos.getY(), basePos.getZ()}), new Integer[]{0, basePos.getX() - 1, basePos.getY(), basePos.getZ()});
                    }
                    if (level.isEmptyBlock(basePos.above())) {
                        oxygenInformationsPerLevel.get(level).set(oxygenInformationsPerLevel.get(level).indexOf(new Integer[]{1, basePos.getX(), basePos.getY() + 1, basePos.getZ()}), new Integer[]{0, basePos.getX(), basePos.getY() + 1, basePos.getZ()});
                    }
                    if (level.isEmptyBlock(basePos.below())) {
                        oxygenInformationsPerLevel.get(level).set(oxygenInformationsPerLevel.get(level).indexOf(new Integer[]{1, basePos.getX(), basePos.getY() - 1, basePos.getZ()}), new Integer[]{0, basePos.getX(), basePos.getY() - 1, basePos.getZ()});
                    }
                    if (level.isEmptyBlock(basePos.south())) {
                        oxygenInformationsPerLevel.get(level).set(oxygenInformationsPerLevel.get(level).indexOf(new Integer[]{1, basePos.getX(), basePos.getY(), basePos.getZ() + 1}), new Integer[]{0, basePos.getX(), basePos.getY(), basePos.getZ() + 1});
                    }
                    if (level.isEmptyBlock(basePos.north())) {
                        oxygenInformationsPerLevel.get(level).set(oxygenInformationsPerLevel.get(level).indexOf(new Integer[]{1, basePos.getX(), basePos.getY(), basePos.getZ() - 1}), new Integer[]{0, basePos.getX(), basePos.getY(), basePos.getZ() - 1});
                    }
                } else {
                    newOxygenInfo.add(oxygenData);
                }
            });
            stop.set(newOxygenInfoCopy.equals(newOxygenInfo));
        }
        oxygenInformationsPerLevel.get(level).clear();
        oxygenInformationsPerLevel.get(level).addAll(newOxygenInfo);
    }

    public static void addOxygenBlocksPerLevel(Level level, OxygenContainerBlockEntity oxygenContainer) {
        if (!oxygenBlocksPerLevel.containsKey(level)) {
            oxygenBlocksPerLevel.put(level, new ArrayList());
        }
        if (!oxygenBlocksPerLevel.get(level).contains(oxygenContainer)) {
            oxygenBlocksPerLevel.get(level).add(oxygenContainer);
            OxygenManager.distributeOxygenForLevel(level);
        }
    }

    public static void removeOxygenBlocksPerLevel(Level level, OxygenContainerBlockEntity oxygenContainer) {
        oxygenBlocksPerLevel.get(level).remove(oxygenContainer);
    }

    public static boolean hasOxygenAt(Level level, BlockPos pos) {
        if (oxygenInformationsPerLevel == null) {
            return false;
        }
        if (!oxygenInformationsPerLevel.containsKey(level)) {
            oxygenInformationsPerLevel.put(level, new ArrayList());
        }
        if (oxygenInformationsPerLevel.get(level) == null) {
            return true;
        }
        return oxygenInformationsPerLevel.get(level).contains(new Integer[]{1, pos.getX(), pos.getY(), pos.getZ()}) || oxygenInformationsPerLevel.get(level).contains(new Integer[]{0, pos.getX(), pos.getY(), pos.getZ()});
    }
}

