/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.rocket_upgrade;

import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;

public class FuelType {
    public static final Codec<Type> CODEC = StringRepresentable.fromEnum(Type::values);
    public static final Codec<Type.Radioactive> RADIOACTIVE_CODEC = StringRepresentable.fromEnum(Type.Radioactive::values);

    public static float getMegametersTraveled(int fuelQuantity, Item fuelItem) {
        Type type = Type.getTypeBasedOnItem(fuelItem);
        if (type != null && type != Type.RADIOACTIVE) {
            return switch (type.ordinal()) {
                case 0 -> 19.22f * (float)fuelQuantity;
                case 1 -> 21.36f * (float)fuelQuantity;
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)type));
            };
        }
        Type.Radioactive radioactiveElement = Type.Radioactive.getTypeBasedOnItem(fuelItem);
        if (radioactiveElement != null && type == Type.RADIOACTIVE) {
            return switch (radioactiveElement.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 23.74f * (float)fuelQuantity;
                case 1 -> 26.38f * (float)fuelQuantity;
                case 2 -> 29.3f * (float)fuelQuantity;
            };
        }
        return 0.0f;
    }

    public static Item getFuelItem(Type type, Type.Radioactive radioactiveElement) {
        if (radioactiveElement == null) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> (Item)ItemsRegistry.FUEL_BUCKET.get();
                case 1 -> (Item)ItemsRegistry.HYDROGEN_BUCKET.get();
                case 2 -> null;
            };
        }
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Item)ItemsRegistry.FUEL_BUCKET.get();
            case 1 -> (Item)ItemsRegistry.HYDROGEN_BUCKET.get();
            case 2 -> {
                switch (radioactiveElement.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield (Item)ItemsRegistry.URANIUM_INGOT.get();
                    }
                    case 1: {
                        yield (Item)ItemsRegistry.NEPTUNIUM_INGOT.get();
                    }
                    case 2: 
                }
                yield (Item)ItemsRegistry.PLUTONIUM_INGOT.get();
            }
        };
    }

    public static Item getItemBasedOnTypeName(String name) {
        if (name.equals(Type.FUEL.getSerializedName())) {
            return (Item)ItemsRegistry.FUEL_BUCKET.get();
        }
        if (name.equals(Type.HYDROGEN.getSerializedName())) {
            return (Item)ItemsRegistry.HYDROGEN_BUCKET.get();
        }
        if (name.equals(Type.Radioactive.URANIUM.getSerializedName())) {
            return (Item)ItemsRegistry.URANIUM_INGOT.get();
        }
        if (name.equals(Type.Radioactive.NEPTUNIUM.getSerializedName())) {
            return (Item)ItemsRegistry.NEPTUNIUM_INGOT.get();
        }
        if (name.equals(Type.Radioactive.PLUTONIUM.getSerializedName())) {
            return (Item)ItemsRegistry.PLUTONIUM_INGOT.get();
        }
        return null;
    }

    public static Item getItemBasedOnLoacation(ResourceLocation location) {
        return (Item)ItemsRegistry.ITEMS.getRegistrar().get(location);
    }

    public static enum Type implements StringRepresentable
    {
        FUEL,
        HYDROGEN,
        RADIOACTIVE;


        public static Type getTypeBasedOnItem(Item item) {
            if (item == null) {
                return null;
            }
            if (item.getDefaultInstance().is((Item)ItemsRegistry.FUEL_BUCKET.get())) {
                return FUEL;
            }
            if (item.getDefaultInstance().is((Item)ItemsRegistry.HYDROGEN_BUCKET.get())) {
                return HYDROGEN;
            }
            return null;
        }

        public static Type fromString(String name) {
            return switch (name) {
                case "fuel" -> FUEL;
                case "hydrogen" -> HYDROGEN;
                case "radioactive" -> RADIOACTIVE;
                default -> null;
            };
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public static enum Radioactive implements StringRepresentable
        {
            URANIUM,
            NEPTUNIUM,
            PLUTONIUM;


            public static Radioactive getTypeBasedOnItem(Item item) {
                if (item == null) {
                    return null;
                }
                if (item.getDefaultInstance().is((Item)ItemsRegistry.URANIUM_INGOT.get())) {
                    return URANIUM;
                }
                if (item.getDefaultInstance().is((Item)ItemsRegistry.NEPTUNIUM_INGOT.get())) {
                    return NEPTUNIUM;
                }
                if (item.getDefaultInstance().is((Item)ItemsRegistry.PLUTONIUM_INGOT.get())) {
                    return PLUTONIUM;
                }
                return null;
            }

            public static Radioactive fromString(String name) {
                return switch (name) {
                    case "uranium" -> URANIUM;
                    case "neptunium" -> NEPTUNIUM;
                    case "plutonium" -> PLUTONIUM;
                    default -> null;
                };
            }

            public String getSerializedName() {
                return this.name().toLowerCase();
            }
        }
    }
}

