/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.systems.energy;

import com.st0x0ef.stellaris.common.systems.SystemsMain;
import com.st0x0ef.stellaris.common.systems.energy.base.EnergyBlock;
import com.st0x0ef.stellaris.common.systems.energy.base.EnergyItem;
import com.st0x0ef.stellaris.common.systems.item.ItemStackHolder;
import com.st0x0ef.stellaris.common.systems.util.Updatable;
import com.st0x0ef.stellaris.platform.systems.energy.EnergyContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EnergyApi {
    private static final Map<Supplier<BlockEntityType<?>>, EnergyBlock<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Block>, EnergyBlock<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<Item>, EnergyItem<?>> ITEM_LOOKUP_MAP = new HashMap();
    private static Map<BlockEntityType<?>, EnergyBlock<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = null;
    private static Map<Block, EnergyBlock<?>> FINALIZED_BLOCK_LOOKUP_MAP = null;
    private static Map<Item, EnergyItem<?>> FINALIZED_ITEM_LOOKUP_MAP = null;

    public static Map<BlockEntityType<?>, EnergyBlock<?>> getBlockEntityRegistry() {
        FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = SystemsMain.finalizeRegistration(BLOCK_ENTITY_LOOKUP_MAP, FINALIZED_BLOCK_ENTITY_LOOKUP_MAP);
        return FINALIZED_BLOCK_ENTITY_LOOKUP_MAP;
    }

    public static Map<Block, EnergyBlock<?>> getBlockRegistry() {
        FINALIZED_BLOCK_LOOKUP_MAP = SystemsMain.finalizeRegistration(BLOCK_LOOKUP_MAP, FINALIZED_BLOCK_LOOKUP_MAP);
        return FINALIZED_BLOCK_LOOKUP_MAP;
    }

    public static Map<Item, EnergyItem<?>> getItemRegistry() {
        FINALIZED_ITEM_LOOKUP_MAP = SystemsMain.finalizeRegistration(ITEM_LOOKUP_MAP, FINALIZED_ITEM_LOOKUP_MAP);
        return FINALIZED_ITEM_LOOKUP_MAP;
    }

    public static EnergyBlock<?> getEnergyBlock(Block block) {
        return EnergyApi.getBlockRegistry().get(block);
    }

    public static EnergyBlock<?> getEnergyBlock(BlockEntityType<?> blockEntity) {
        return EnergyApi.getBlockEntityRegistry().get(blockEntity);
    }

    public static EnergyItem<?> getEnergyItem(Item item) {
        return EnergyApi.getItemRegistry().get(item);
    }

    public static <T extends EnergyContainer & Updatable> T getAPIEnergyContainer(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        EnergyBlock<?> getter = EnergyApi.getEnergyBlock(state.getBlock());
        if (getter == null && entity != null) {
            Block block;
            EnergyBlock<?> energyGetter;
            getter = EnergyApi.getEnergyBlock(entity.getType());
            if (getter == null && entity instanceof EnergyBlock) {
                getter = energyGetter = (EnergyBlock<?>)entity;
            }
            if (getter == null && (block = state.getBlock()) instanceof EnergyBlock) {
                getter = energyGetter = (EnergyBlock)block;
            }
        }
        if (getter == null) {
            return null;
        }
        return (T)getter.getEnergyStorage(level, pos, state, entity, direction);
    }

    public static void registerEnergyBlockEntity(Supplier<BlockEntityType<?>> block, EnergyBlock<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlockEntity(EnergyBlock<?> getter, Supplier<BlockEntityType<?>> ... blocks) {
        for (Supplier<BlockEntityType<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyBlock(Supplier<Block> block, EnergyBlock<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlock(EnergyBlock<?> getter, Supplier<Block> ... blocks) {
        for (Supplier<Block> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyItem(Supplier<Item> item, EnergyItem<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerEnergyItem(EnergyItem<?> getter, Supplier<Item> ... items) {
        for (Supplier<Item> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    public static long distributeEnergyNearby(BlockEntity energyBlock, @Nullable Direction extractDirection, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.getLevel(), energyBlock.getBlockPos(), extractDirection, amount);
    }

    public static long distributeEnergyNearby(BlockEntity energyBlock, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.getLevel(), energyBlock.getBlockPos(), null, amount);
    }

    public static long distributeEnergyNearby(Level level, BlockPos energyPos, @Nullable Direction extractDirection, long amount) {
        if (level == null) {
            return -1L;
        }
        if (energyPos == null) {
            return -1L;
        }
        if (level.getBlockEntity(energyPos) == null) {
            return -1L;
        }
        EnergyContainer internalEnergy = EnergyContainer.of(level, energyPos, level.getBlockState(energyPos), level.getBlockEntity(energyPos), extractDirection);
        if (internalEnergy == null) {
            return -1L;
        }
        long amountToDistribute = internalEnergy.extractEnergy(amount, true);
        if (amountToDistribute == 0L) {
            return 0L;
        }
        List<EnergyContainer> list = Direction.stream().map(direction -> EnergyContainer.of(level, energyPos.relative(direction), direction.getOpposite())).filter(Objects::nonNull).toList();
        int receiverCount = list.size();
        for (EnergyContainer energy : list) {
            if (energy == null) continue;
            long inserted = EnergyApi.moveEnergy(internalEnergy, energy, amountToDistribute / (long)receiverCount, false);
            amountToDistribute -= inserted;
            --receiverCount;
        }
        return amount - amountToDistribute;
    }

    public static long moveEnergy(EnergyContainer from, EnergyContainer to, long amount, boolean simulate) {
        long extracted = from.extractEnergy(amount, true);
        long inserted = to.insertEnergy(extracted, true);
        long simulatedExtraction = from.extractEnergy(inserted, true);
        if (!simulate && inserted > 0L && simulatedExtraction == inserted) {
            from.extractEnergy(inserted, false);
            to.insertEnergy(inserted, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveEnergy(ItemStackHolder from, ItemStackHolder to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from);
        EnergyContainer toEnergy = EnergyContainer.of(to);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(BlockEntity from, BlockEntity to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from, null);
        EnergyContainer toEnergy = EnergyContainer.of(to, null);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(Level level, BlockPos fromPos, @Nullable Direction fromDirection, BlockPos toPos, @Nullable Direction toDirection, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(level, fromPos, fromDirection);
        EnergyContainer toEnergy = EnergyContainer.of(level, toPos, toDirection);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(BlockEntity from, Direction direction, ItemStackHolder to, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from, direction);
        EnergyContainer toEnergy = EnergyContainer.of(to);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(ItemStackHolder from, BlockEntity to, Direction direction, long amount, boolean simulate) {
        EnergyContainer fromEnergy = EnergyContainer.of(from);
        EnergyContainer toEnergy = EnergyContainer.of(to, direction);
        if (fromEnergy == null || toEnergy == null) {
            return 0L;
        }
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }
}

