/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.systems.item.utils;

import com.st0x0ef.stellaris.common.systems.item.base.ItemContainerExtras;
import com.st0x0ef.stellaris.platform.systems.item.base.ItemContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SlotItemContainer<T extends ItemContainer & ItemContainerExtras>
extends Slot {
    private static final Container EMPTY = new SimpleContainer(0);
    private final T container;

    public SlotItemContainer(T container, int slot, int x, int y) {
        super(EMPTY, slot, x, y);
        this.container = container;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.container.isItemValid(this.index, stack);
    }

    @NotNull
    public ItemStack getItem() {
        return this.container.getStackInSlot(this.index);
    }

    public void set(@NotNull ItemStack stack) {
        ((ItemContainerExtras)this.container).setStackInSlot(this.index, stack);
        this.setChanged();
    }

    public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return this.container.getSlotLimit(this.index);
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        int maxInput = stack.getMaxStackSize();
        ItemStack maxAdd = stack.copyWithCount(maxInput);
        ItemStack currentStack = this.container.getStackInSlot(this.index);
        ((ItemContainerExtras)this.container).setStackInSlot(this.index, ItemStack.EMPTY);
        ItemStack inserted = this.container.insertIntoSlot(this.index, maxAdd, true);
        ((ItemContainerExtras)this.container).setStackInSlot(this.index, currentStack);
        return inserted.getCount();
    }

    public boolean mayPickup(Player playerIn) {
        return !this.container.extractFromSlot(this.index, 1, true).isEmpty();
    }

    @NotNull
    public ItemStack remove(int amount) {
        return this.container.extractFromSlot(this.index, amount, false);
    }
}

