/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.entities.LanderEntity;
import com.st0x0ef.stellaris.common.entities.RocketEntity;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.platform.TeleportUtil;
import java.util.Locale;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Utils {
    public static void transfertInventory(RocketEntity rocket, LanderEntity lander) {
        Container rocketContainer = rocket.getInventory();
        Container landerContainer = lander.getInventory();
        ItemStack rocketStack = new ItemStack((ItemLike)ItemsRegistry.ROCKET.get());
        rocketContainer.setItem(13, rocketStack);
        for (int i = 0; i <= lander.getInventory().getContainerSize() - 1; ++i) {
            landerContainer.setItem(i, rocketContainer.getItem(i));
        }
    }

    public static LanderEntity createLanderFromRocket(Player player, RocketEntity rocket, int yPos) {
        LanderEntity lander = new LanderEntity(player.level());
        lander.setPos(player.getX(), yPos, player.getZ());
        Utils.transfertInventory(rocket, lander);
        rocket.discard();
        return lander;
    }

    public static void teleportEntity(Entity entity, Planet destination) {
        if (entity.level().isClientSide() || !entity.canChangeDimensions()) {
            return;
        }
        entity.setNoGravity(false);
        entity.level().getServer().getAllLevels().forEach(level -> {
            if (level.dimension().location().equals((Object)destination.dimension())) {
                TeleportUtil.teleportToPlanet(entity, level, 600);
                entity.setPos(entity.getX(), 600.0, entity.getZ());
            }
        });
    }

    public static void changeDimension(Player player, Planet destination) {
        if (player.level().isClientSide()) {
            return;
        }
        Entity vehicle = player.getVehicle();
        if (vehicle instanceof RocketEntity) {
            RocketEntity rocket = (RocketEntity)vehicle;
            player.stopRiding();
            Utils.teleportEntity((Entity)player, destination);
            LanderEntity lander = Utils.createLanderFromRocket(player, rocket, 600);
            player.closeContainer();
            player.level().addFreshEntity((Entity)lander);
            player.startRiding((Entity)lander);
        } else {
            player.closeContainer();
            Utils.teleportEntity((Entity)player, destination);
        }
    }

    public static double changeLastDigitToEven(double number) {
        Object numberStr = Double.toString(number);
        int decimalIndex = ((String)numberStr).indexOf(46);
        if (decimalIndex != -1) {
            String beforeDecimal = ((String)numberStr).substring(0, decimalIndex + 1);
            Object afterDecimal = ((String)numberStr).substring(decimalIndex + 1);
            char lastChar = ((String)afterDecimal).charAt(((String)afterDecimal).length() - 1);
            if ((lastChar - 48) % 2 != 0) {
                afterDecimal = ((String)afterDecimal).substring(0, ((String)afterDecimal).length() - 1) + "2";
            }
            numberStr = beforeDecimal + (String)afterDecimal;
        }
        return Double.parseDouble((String)numberStr);
    }

    public static int getColorHexCode(String colorName) {
        return switch (colorName.toLowerCase()) {
            case "black" -> 0;
            case "white" -> 0xFFFFFF;
            case "red" -> 0xFF0000;
            case "green" -> 32768;
            case "blue" -> 255;
            case "yellow" -> 0xFFFF00;
            case "cyan" -> 65535;
            case "magenta" -> 0xFF00FF;
            case "gray" -> 0x808080;
            case "maroon" -> 0x800000;
            case "olive" -> 0x808000;
            case "purple" -> 0x800080;
            case "teal" -> 32896;
            case "navy" -> 128;
            case "orange" -> 16753920;
            case "brown" -> 0xA52A2A;
            case "lime" -> 65280;
            case "pink" -> 16761035;
            case "coral" -> 16744272;
            case "gold" -> 16766720;
            case "silver" -> 0xC0C0C0;
            case "beige" -> 16119260;
            case "lavender" -> 15132410;
            case "turquoise" -> 4251856;
            case "salmon" -> 16416882;
            case "khaki" -> 15787660;
            case "darkred" -> 0x8B0000;
            case "dark_red" -> 0x8B0000;
            case "rainbow" -> Utils.generateRandomHexColor();
            default -> 0xFFFFFF;
        };
    }

    public static int generateRandomHexColor() {
        Random random = new Random();
        return random.nextInt(0x1000000);
    }

    public static String betterIntToString(int i) {
        if (i == 0) {
            return "0";
        }
        return i % 1000 + "K";
    }

    public static Component getMessageComponent(String text, String color) {
        return Component.literal((String)text).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)Utils.getColorHexCode(color))));
    }

    public static Component getMessageComponent(String text, int color) {
        return Component.literal((String)text).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)color)));
    }

    public static Component getMessageComponent(String text) {
        return Component.literal((String)text).setStyle(Style.EMPTY);
    }

    public static int getPlayerCountInDimension(MinecraftServer server, ResourceLocation dimensionKey) {
        ServerLevel dimension = server.getLevel(Utils.getPlanetLevel(dimensionKey));
        if (dimension == null) {
            return 0;
        }
        return dimension.players().size();
    }

    public static <T extends Enum<T>> Codec<T> EnumCodec(Class<T> e) {
        Function<String, Enum> stringToEnum = s -> Enum.valueOf(e, s.toUpperCase(Locale.ROOT));
        Function<Enum, String> enumToString = enumValue -> enumValue.name();
        return Codec.STRING.xmap(stringToEnum, enumToString);
    }

    public static float MCGToMPS2(float MCG) {
        return 122.58312f * MCG;
    }

    public static double MPS2ToMCG(float MPS2) {
        if (MPS2 > 0.0f) {
            return Math.floor(0.00816 * (double)MPS2 * 100000.0) / 100000.0;
        }
        if (MPS2 < 0.0f) {
            return Math.ceil(0.00816 * (double)MPS2 * 100000.0) / 100000.0;
        }
        return 0.0;
    }

    public static int findSmallerNumber(int value1, int value2) {
        return Math.min(value1, value2);
    }

    public static int findBiggerNumber(int value1, int value2) {
        return Math.max(value1, value2);
    }

    public static void disableFlyAntiCheat(Player player, boolean condition) {
        if (player instanceof ServerPlayer && condition) {
            ((ServerPlayer)player).connection.aboveGroundTickCount = 0;
        }
    }

    public static boolean isLivingInJetSuit(LivingEntity entity) {
        if (!Utils.isLivingInArmor(entity, EquipmentSlot.HEAD, (Item)ItemsRegistry.JETSUIT_HELMET.get())) {
            return false;
        }
        if (!Utils.isLivingInArmor(entity, EquipmentSlot.CHEST, (Item)ItemsRegistry.JETSUIT_SUIT.get())) {
            return false;
        }
        if (!Utils.isLivingInArmor(entity, EquipmentSlot.LEGS, (Item)ItemsRegistry.JETSUIT_LEGGINGS.get())) {
            return false;
        }
        return Utils.isLivingInArmor(entity, EquipmentSlot.FEET, (Item)ItemsRegistry.JETSUIT_BOOTS.get());
    }

    public static boolean isLivingInArmor(LivingEntity entity, EquipmentSlot slot, Item item) {
        return entity.getItemBySlot(slot).getItem() == item;
    }

    public static ResourceKey<Level> getPlanetLevel(ResourceLocation planet) {
        return ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)planet), (ResourceLocation)planet);
    }
}

