/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin;

import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class EntityEatMixin
extends LivingEntity {
    @Shadow
    public abstract void playSound(SoundEvent var1, float var2, float var3);

    protected EntityEatMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    private void cancelEat(Level level, ItemStack food, CallbackInfoReturnable<ItemStack> cir) {
        if (PlanetUtil.isPlanet(level.dimension().location()) && !PlanetUtil.hasOxygen(level.dimension().location()) && !food.is(TagRegistry.SPACE_FOOD)) {
            cir.setReturnValue((Object)food);
        }
    }
}

