/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.st0x0ef.stellaris.client.skys.record.SkyPropertiesData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.world.level.material.FogType;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=900)
public abstract class LevelRendererMixin {
    @Mutable
    @Shadow
    private ClientLevel level;

    @Shadow
    protected abstract boolean doesMobEffectBlockSky(Camera var1);

    @Inject(method={"renderSky(Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FLnet/minecraft/client/Camera;ZLjava/lang/Runnable;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderCustomSkyboxes(Matrix4f matrix4f, Matrix4f projectionMatrix, float tickDelta, Camera camera, boolean thickFog, Runnable fogCallback, CallbackInfo ci) {
        FogType cameraSubmersionType = camera.getFluidInCamera();
        if (!thickFog && cameraSubmersionType != FogType.POWDER_SNOW && cameraSubmersionType != FogType.LAVA && cameraSubmersionType != FogType.WATER && !this.doesMobEffectBlockSky(camera)) {
            PoseStack matrixStack = new PoseStack();
            matrixStack.mulPose(matrix4f);
            if (SkyPropertiesData.SKY_PROPERTIES.containsKey(this.level.dimension())) {
                SkyPropertiesData.SKY_PROPERTIES.get(this.level.dimension()).renderSky(matrixStack, projectionMatrix, tickDelta, camera);
            }
        }
        ci.cancel();
    }

    @Inject(method={"renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelCloudRenderer(PoseStack poseStack, Matrix4f frustumMatrix, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (SkyPropertiesData.SKY_PROPERTIES.containsKey(this.level.dimension()) && SkyPropertiesData.SKY_PROPERTIES.get(this.level.dimension()).getRenderer().shouldRemoveCloud().booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelSnowAndRainRenderer(LightTexture lightTexture, float partialTick, double camX, double camY, double camZ, CallbackInfo ci) {
        if (SkyPropertiesData.SKY_PROPERTIES.containsKey(this.level.dimension()) && SkyPropertiesData.SKY_PROPERTIES.get(this.level.dimension()).getRenderer().shouldRemoveSnowAndRain().booleanValue()) {
            ci.cancel();
        }
    }
}

