/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin.client;

import com.st0x0ef.stellaris.common.entities.LanderEntity;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.network.packets.KeyHandlerPacket;
import dev.architectury.networking.NetworkManager;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyboardHandler.class})
public abstract class PlayerLanderKeyMixin {
    @Final
    @Shadow
    private Minecraft minecraft;

    @Inject(at={@At(value="TAIL")}, method={"keyPress(JIIII)V"})
    private void keyPress(long windowPointer, int key, int scanCode, int action, int modifiers, CallbackInfo info) {
        if (windowPointer == this.minecraft.getWindow().getWindow()) {
            if (this.minecraft.player == null) {
                return;
            }
            PlayerLanderKeyMixin.sendKeyToServerAndClientHashMap(key, action, (Player)this.minecraft.player, this.minecraft.options.keyUp, KeyVariables.KEY_UP, "key_up", KeyVariables.isHoldingUp((Player)this.minecraft.player));
            PlayerLanderKeyMixin.sendKeyToServerAndClientHashMap(key, action, (Player)this.minecraft.player, this.minecraft.options.keyDown, KeyVariables.KEY_DOWN, "key_down", KeyVariables.isHoldingDown((Player)this.minecraft.player));
            PlayerLanderKeyMixin.sendKeyToServerAndClientHashMap(key, action, (Player)this.minecraft.player, this.minecraft.options.keyRight, KeyVariables.KEY_RIGHT, "key_right", KeyVariables.isHoldingRight((Player)this.minecraft.player));
            PlayerLanderKeyMixin.sendKeyToServerAndClientHashMap(key, action, (Player)this.minecraft.player, this.minecraft.options.keyLeft, KeyVariables.KEY_LEFT, "key_left", KeyVariables.isHoldingLeft((Player)this.minecraft.player));
            if (this.minecraft.player.getVehicle() instanceof LanderEntity) {
                this.keyEvent((Player)this.minecraft.player, this.minecraft.options.keyJump, key, scanCode, action, modifiers);
            }
        }
    }

    @Unique
    public void keyEvent(Player player, KeyMapping keyWanted, int key, int scanCode, int action, int modifiers) {
        if (keyWanted.getDefaultKey().getValue() == key && action == 0 && KeyVariables.isHoldingJump(player) || KeyVariables.isHoldingJump(player)) {
            KeyVariables.KEY_JUMP.put(player.getUUID(), false);
            NetworkManager.sendToServer((CustomPacketPayload)new KeyHandlerPacket("key_jump", false));
        } else if (keyWanted.getDefaultKey().getValue() == key && action == 1 && !KeyVariables.isHoldingJump(player)) {
            KeyVariables.KEY_JUMP.put(player.getUUID(), true);
            NetworkManager.sendToServer((CustomPacketPayload)new KeyHandlerPacket("key_jump", true));
        }
    }

    @Unique
    private static void sendKeyToServerAndClientHashMap(int key, int action, Player player, KeyMapping keyWanted, Map<UUID, Boolean> variableKey, String keyString, boolean isPressed) {
        if (player == null) {
            return;
        }
        if (keyWanted.getDefaultKey().getValue() == key && action == 0 && isPressed || isPressed) {
            variableKey.put(player.getUUID(), false);
            NetworkManager.sendToServer((CustomPacketPayload)new KeyHandlerPacket(keyString, false));
        }
        if (keyWanted.getDefaultKey().getValue() == key && action == 1 && !isPressed) {
            variableKey.put(player.getUUID(), true);
            NetworkManager.sendToServer((CustomPacketPayload)new KeyHandlerPacket(keyString, true));
        }
    }
}

