/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.data;

import com.st0x0ef.stellaris.common.systems.data.DataManager;
import java.util.function.Supplier;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentType;

public class NeoDataManager<T>
implements DataManager<T> {
    private final Supplier<AttachmentType<T>> attachmentType;

    public NeoDataManager(Supplier<AttachmentType<T>> attachmentType) {
        this.attachmentType = attachmentType;
    }

    @Override
    public T getData(Object dataHolder) {
        if (dataHolder instanceof AttachmentHolder) {
            AttachmentHolder holder = (AttachmentHolder)dataHolder;
            return (T)holder.getData(this.attachmentType);
        }
        throw new IllegalArgumentException(String.valueOf(dataHolder) + " is not an attachment holder");
    }

    @Override
    public T getDataOrThrow(Object dataHolder) {
        if (!this.hasData(dataHolder)) {
            throw new RuntimeException(String.valueOf(dataHolder) + "is not initialized");
        }
        return this.getData(dataHolder);
    }

    @Override
    public T getDataOrInit(Object dataHolder, T data) {
        if (!this.hasData(dataHolder)) {
            this.setData(dataHolder, data);
        }
        return this.getData(dataHolder);
    }

    @Override
    public T setData(Object dataHolder, T data) {
        if (dataHolder instanceof AttachmentHolder) {
            AttachmentHolder holder = (AttachmentHolder)dataHolder;
            return (T)holder.setData(this.attachmentType, data);
        }
        throw new IllegalArgumentException(String.valueOf(dataHolder) + " is not an attachment holder");
    }

    @Override
    public boolean hasData(Object dataHolder) {
        if (dataHolder instanceof AttachmentHolder) {
            AttachmentHolder holder = (AttachmentHolder)dataHolder;
            return holder.hasData(this.attachmentType);
        }
        throw new IllegalArgumentException(String.valueOf(dataHolder) + " is not an attachment holder");
    }
}

