/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.data;

import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.common.systems.data.DataManager;
import com.st0x0ef.stellaris.common.systems.data.DataManagerBuilder;
import com.st0x0ef.stellaris.common.systems.data.DataManagerRegistry;
import com.st0x0ef.stellaris.neoforge.systems.data.NeoDataManager;
import com.st0x0ef.stellaris.neoforge.systems.data.NeoDataManagerBuilder;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoDataManagerRegistry
implements DataManagerRegistry {
    private final DeferredRegister<AttachmentType<?>> register;
    private final String modid;

    public NeoDataManagerRegistry(String modid) {
        this.register = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)modid);
        this.modid = modid;
    }

    @Override
    public <T> DataManager<T> register(@NotNull String name, @NotNull Supplier<T> factory, @Nullable Codec<T> codec, boolean copyOnDeath) {
        ResourceLocation id = new ResourceLocation(this.modid, name);
        AttachmentType.Builder builder = AttachmentType.builder(factory);
        if (codec != null) {
            builder.serialize(codec);
        }
        if (copyOnDeath) {
            builder.copyOnDeath();
        }
        DeferredHolder type = this.register.register(name, () -> ((AttachmentType.Builder)builder).build());
        return new NeoDataManager(type);
    }

    @Override
    public <T> DataManagerBuilder<T> builder(Supplier<T> factory) {
        return new NeoDataManagerBuilder<T>(this.register, factory);
    }

    public String getModid() {
        return this.modid;
    }
}

