/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.generic;

import com.st0x0ef.stellaris.common.systems.generic.base.BlockContainerLookup;
import com.st0x0ef.stellaris.common.systems.generic.base.EntityContainerLookup;
import com.st0x0ef.stellaris.common.systems.generic.base.ItemContainerLookup;
import com.st0x0ef.stellaris.neoforge.systems.generic.NeoForgeBlockContainerLookup;
import com.st0x0ef.stellaris.neoforge.systems.generic.NeoForgeEntityContainerLookup;
import com.st0x0ef.stellaris.neoforge.systems.generic.NeoForgeItemContainerLookup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class NeoForgeCapsHandler {
    private static final List<NeoForgeBlockContainerLookup<?, ?>> BLOCK_LOOKUPS = new ArrayList();
    private static final List<NeoForgeItemContainerLookup<?, ?>> ITEM_LOOKUPS = new ArrayList();
    private static final List<NeoForgeEntityContainerLookup<?, ?>> ENTITY_LOOKUPS = new ArrayList();

    public static <T, C> NeoForgeBlockContainerLookup<T, C> registerBlockLookup(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        NeoForgeBlockContainerLookup<T, C> lookup = new NeoForgeBlockContainerLookup<T, C>(name, typeClass, contextClass);
        BLOCK_LOOKUPS.add(lookup);
        return lookup;
    }

    public static <T, C> NeoForgeItemContainerLookup<T, C> registerItemLookup(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        NeoForgeItemContainerLookup<T, C> lookup = new NeoForgeItemContainerLookup<T, C>(name, typeClass, contextClass);
        ITEM_LOOKUPS.add(lookup);
        return lookup;
    }

    public static <T, C> NeoForgeEntityContainerLookup<T, C> registerEntityLookup(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        NeoForgeEntityContainerLookup<T, C> lookup = new NeoForgeEntityContainerLookup<T, C>(name, typeClass, contextClass);
        ENTITY_LOOKUPS.add(lookup);
        return lookup;
    }

    public static <T, C> BlockCapability<T, C> getAsCapability(BlockContainerLookup<T, C> lookup) {
        if (lookup instanceof NeoForgeBlockContainerLookup) {
            return ((NeoForgeBlockContainerLookup)lookup).getCapability();
        }
        return null;
    }

    public static <T, C> ItemCapability<T, C> getAsCapability(ItemContainerLookup<T, C> lookup) {
        if (lookup instanceof NeoForgeItemContainerLookup) {
            return ((NeoForgeItemContainerLookup)lookup).getCapability();
        }
        return null;
    }

    public static <T, C> EntityCapability<T, C> getAsCapability(EntityContainerLookup<T, C> lookup) {
        if (lookup instanceof NeoForgeEntityContainerLookup) {
            return ((NeoForgeEntityContainerLookup)lookup).getCapability();
        }
        return null;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        for (NeoForgeBlockContainerLookup<?, ?> neoForgeBlockContainerLookup : BLOCK_LOOKUPS) {
            neoForgeBlockContainerLookup.registerWithCaps(event);
        }
        for (NeoForgeItemContainerLookup neoForgeItemContainerLookup : ITEM_LOOKUPS) {
            neoForgeItemContainerLookup.registerWithCaps(event);
        }
        for (NeoForgeEntityContainerLookup neoForgeEntityContainerLookup : ENTITY_LOOKUPS) {
            neoForgeEntityContainerLookup.registerWithCaps(event);
        }
    }
}

