/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.systems.generic;

import com.st0x0ef.stellaris.common.systems.SystemsMain;
import com.st0x0ef.stellaris.common.systems.generic.base.ItemContainerLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class NeoForgeItemContainerLookup<T, C>
implements ItemContainerLookup<T, C> {
    private final ItemCapability<T, C> capability;
    private final Map<Supplier<Item>, ItemContainerLookup.ItemGetter<T, C>> blockEntityGetterMap = new HashMap<Supplier<Item>, ItemContainerLookup.ItemGetter<T, C>>();
    private Map<Item, ItemContainerLookup.ItemGetter<T, C>> blockEntityMap = null;

    public NeoForgeItemContainerLookup(ItemCapability<T, C> cap) {
        this.capability = cap;
    }

    public NeoForgeItemContainerLookup(ResourceLocation name, Class<T> typeClass, Class<C> contextClass) {
        this(ItemCapability.create((ResourceLocation)name, typeClass, contextClass));
    }

    @Override
    public T find(ItemStack stack, @Nullable C context) {
        return (T)stack.getCapability(this.capability, context);
    }

    @Override
    public void registerItems(ItemContainerLookup.ItemGetter<T, C> getter, Supplier<Item> ... containers) {
        for (Supplier<Item> container : containers) {
            this.blockEntityGetterMap.put(container, getter);
        }
    }

    public void registerWithCaps(RegisterCapabilitiesEvent event) {
        this.getBlockEntityMap().forEach((blockEntityType, blockGetter) -> event.registerItem(this.capability, blockGetter::getContainer, new ItemLike[]{blockEntityType}));
    }

    public Map<Item, ItemContainerLookup.ItemGetter<T, C>> getBlockEntityMap() {
        this.blockEntityMap = SystemsMain.finalizeRegistration(this.blockEntityGetterMap, this.blockEntityMap);
        return this.blockEntityMap;
    }

    ItemCapability<T, C> getCapability() {
        return this.capability;
    }
}

