/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft;

import andrews.table_top_craft.network.TTCNetwork;
import andrews.table_top_craft.registry.TTCBlocks;
import andrews.table_top_craft.registry.TTCItems;
import andrews.table_top_craft.registry.TTCLootItemFunctions;
import andrews.table_top_craft.registry.TTCTileEntities;
import andrews.table_top_craft.tile_entities.model.chess.ChessBoardPlateModel;
import andrews.table_top_craft.tile_entities.model.chess.ChessHighlightModel;
import andrews.table_top_craft.tile_entities.model.chess.ChessTilesInfoModel;
import andrews.table_top_craft.tile_entities.model.piece_figure.ChessPieceFigureStandModel;
import andrews.table_top_craft.tile_entities.model.tic_tac_toe.TicTacToeModel;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="table_top_craft")
public class TableTopCraft {
    @Nullable
    public static ShaderInstance rendertypeSolidBlockEntityShader;
    public static final CreativeModeTab TABLE_TOP_CRAFT_GROUP;

    public static ShaderInstance getSolidBlockEntityShader() {
        return Objects.requireNonNull(rendertypeSolidBlockEntityShader, "Attempted to call getSolidBlockEntityShader before shaders have finished loading.");
    }

    public TableTopCraft() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TTCItems.ITEMS.register(modEventBus);
        TTCBlocks.BLOCKS.register(modEventBus);
        TTCTileEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        TTCLootItemFunctions.ITEM_FUNCTION_TYPES.register(modEventBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
            modEventBus.addListener(this::setupLayers);
            modEventBus.addListener(this::registerShaders);
        });
        modEventBus.addListener(EventPriority.LOWEST, this::setupCommon);
        try {
            Class<?> clazz = Class.forName("net.optifine.Config");
            if (clazz != null) {
                ModLoader.get().addWarning(new ModLoadingWarning(ModLoadingContext.get().getActiveContainer().getModInfo(), ModLoadingStage.CONSTRUCT, ChatFormatting.YELLOW + "Table Top Craft" + ChatFormatting.RESET + "\nOptifine Shaders and Table Top Craft are" + ChatFormatting.RED + ChatFormatting.BOLD + " incompatible " + ChatFormatting.RESET + "with each other.", new Object[0]));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void setupCommon(FMLCommonSetupEvent event) {
        TTCNetwork.setupMessages();
    }

    void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(TTCTileEntities::registerTileRenders);
    }

    void setupLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ChessBoardPlateModel.CHESS_BOARD_PLATE_LAYER, ChessBoardPlateModel::createBodyLayer);
        event.registerLayerDefinition(ChessHighlightModel.CHESS_HIGHLIGHT_LAYER, ChessHighlightModel::createBodyLayer);
        event.registerLayerDefinition(ChessTilesInfoModel.CHESS_TILES_INFO_LAYER, ChessTilesInfoModel::createBodyLayer);
        event.registerLayerDefinition(ChessPieceFigureStandModel.CHESS_PIECE_FIGURE_LAYER, ChessPieceFigureStandModel::createBodyLayer);
        event.registerLayerDefinition(TicTacToeModel.TIC_TAC_TOE_LAYER, TicTacToeModel::createBodyLayer);
    }

    void registerShaders(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("table_top_craft", "rendertype_solid"), DefaultVertexFormat.f_85811_), shader -> {
                rendertypeSolidBlockEntityShader = shader;
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        TABLE_TOP_CRAFT_GROUP = new CreativeModeTab("table_top_craft.tab"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Item.f_41373_.getOrDefault(TTCBlocks.OAK_CHESS.get(), Items.f_41852_));
            }
        };
    }
}

