/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.game_logic.chess.board.moves;

import andrews.table_top_craft.game_logic.chess.board.Board;
import andrews.table_top_craft.game_logic.chess.board.moves.NullMove;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;

public abstract class BaseMove {
    public static final BaseMove NULL_MOVE = new NullMove();
    protected final Board board;
    protected final BasePiece movedPiece;
    protected final int destinationCoordinate;
    protected final boolean isFirstMove;

    BaseMove(Board board, BasePiece movedPiece, int destinationCoordinate) {
        this.board = board;
        this.movedPiece = movedPiece;
        this.destinationCoordinate = destinationCoordinate;
        this.isFirstMove = movedPiece.isFirstMove();
    }

    BaseMove(Board board, int destinationCoordinate) {
        this.board = board;
        this.destinationCoordinate = destinationCoordinate;
        this.movedPiece = null;
        this.isFirstMove = false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.destinationCoordinate;
        result = 31 * result + this.movedPiece.hashCode();
        result = 31 * result + this.movedPiece.getPiecePosition();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseMove)) {
            return false;
        }
        BaseMove otherMove = (BaseMove)object;
        return this.getCurrentCoordinate() == otherMove.getCurrentCoordinate() && this.getDestinationCoordinate() == otherMove.getDestinationCoordinate() && this.getMovedPiece().equals(otherMove.getMovedPiece());
    }

    public Board getBoard() {
        return this.board;
    }

    public int getCurrentCoordinate() {
        return this.movedPiece.getPiecePosition();
    }

    public int getDestinationCoordinate() {
        return this.destinationCoordinate;
    }

    public BasePiece getMovedPiece() {
        return this.movedPiece;
    }

    public boolean isAttack() {
        return false;
    }

    public boolean isCastlingMove() {
        return false;
    }

    public boolean isEnPassantMove() {
        return false;
    }

    public BasePiece getAttackedPiece() {
        return null;
    }

    public Board execute() {
        Board.Builder builder = new Board.Builder();
        for (BasePiece piece : this.board.getCurrentChessPlayer().getActivePieces()) {
            if (this.movedPiece.equals(piece)) continue;
            builder.setPiece(piece);
        }
        for (BasePiece piece : this.board.getCurrentChessPlayer().getOpponent().getActivePieces()) {
            builder.setPiece(piece);
        }
        builder.setPiece(this.movedPiece.movePiece(this));
        builder.setMoveMaker(this.board.getCurrentChessPlayer().getOpponent().getPieceColor());
        return builder.build();
    }

    public String saveToNBT() {
        return "";
    }

    public String getColorForPiece(BasePiece piece) {
        return piece.getPieceColor().isWhite() ? "W" : "B";
    }
}

